/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.ParameterContentData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.mutable.MutableDouble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvocationSequenceDataHelper {
    private InvocationSequenceDataHelper() {
    }

    public static boolean hasCapturedParametersInInvocationSequence(InvocationSequenceData data) {
        return null != data.getParameterContentData() && !data.getParameterContentData().isEmpty();
    }

    public static boolean hasCapturedParameters(InvocationSequenceData data) {
        if (InvocationSequenceDataHelper.hasCapturedParametersInInvocationSequence(data)) {
            return true;
        }
        return InvocationSequenceDataHelper.hasTimerData(data) && null != data.getTimerData().getParameterContentData() && !data.getTimerData().getParameterContentData().isEmpty();
    }

    public static List<ParameterContentData> getCapturedParameters(InvocationSequenceData data, boolean sorted) {
        if (!InvocationSequenceDataHelper.hasCapturedParameters(data)) {
            return Collections.emptyList();
        }
        ArrayList<ParameterContentData> parameterContents = new ArrayList<ParameterContentData>();
        if (CollectionUtils.isNotEmpty(data.getParameterContentData())) {
            for (ParameterContentData contentData : data.getParameterContentData()) {
                if (parameterContents.contains(contentData)) continue;
                parameterContents.add(contentData);
            }
        }
        if (InvocationSequenceDataHelper.hasTimerData(data) && CollectionUtils.isNotEmpty(data.getTimerData().getParameterContentData())) {
            for (ParameterContentData contentData : data.getTimerData().getParameterContentData()) {
                if (parameterContents.contains(contentData)) continue;
                parameterContents.add(contentData);
            }
        }
        if (sorted) {
            Collections.sort(parameterContents);
        }
        return parameterContents;
    }

    public static boolean hasTimerData(InvocationSequenceData data) {
        return null != data.getTimerData();
    }

    public static boolean hasHttpTimerData(InvocationSequenceData data) {
        return data.getTimerData() instanceof HttpTimerData;
    }

    public static boolean hasLoggingData(InvocationSequenceData data) {
        return null != data.getLoggingData();
    }

    public static boolean hasExceptionData(InvocationSequenceData data) {
        return null != data.getExceptionSensorDataObjects() && !data.getExceptionSensorDataObjects().isEmpty();
    }

    public static boolean hasSQLData(InvocationSequenceData data) {
        return null != data.getSqlStatementData() && 1L == data.getSqlStatementData().getCount();
    }

    public static boolean hasParentElementInSequence(InvocationSequenceData data) {
        return null != data.getParentSequence();
    }

    public static boolean isRootElementInSequence(InvocationSequenceData data) {
        return !InvocationSequenceDataHelper.hasParentElementInSequence(data);
    }

    public static boolean hasNestedSqlStatements(InvocationSequenceData data) {
        return null != data.isNestedSqlStatements() && data.isNestedSqlStatements() != false;
    }

    public static boolean hasNestedExceptions(InvocationSequenceData data) {
        return null != data.isNestedExceptions() && data.isNestedExceptions() != false;
    }

    public static double calculateDuration(InvocationSequenceData data) {
        double duration = -1.0;
        if (InvocationSequenceDataHelper.hasTimerData(data)) {
            duration = data.getTimerData().getDuration();
        } else if (InvocationSequenceDataHelper.hasSQLData(data)) {
            duration = data.getSqlStatementData().getDuration();
        } else if (InvocationSequenceDataHelper.isRootElementInSequence(data)) {
            duration = data.getDuration();
        }
        return duration;
    }

    public static double computeNestedDuration(InvocationSequenceData data) {
        if (data.getNestedSequences().isEmpty()) {
            return 0.0;
        }
        double nestedDuration = 0.0;
        boolean added = false;
        for (InvocationSequenceData nestedData : data.getNestedSequences()) {
            if (InvocationSequenceDataHelper.hasTimerData(nestedData)) {
                nestedDuration += nestedData.getTimerData().getDuration();
                added = true;
            } else if (InvocationSequenceDataHelper.hasSQLData(nestedData)) {
                nestedDuration += nestedData.getSqlStatementData().getDuration();
                added = true;
            }
            if (!added && !nestedData.getNestedSequences().isEmpty()) {
                nestedDuration += InvocationSequenceDataHelper.computeNestedDuration(nestedData);
            }
            added = false;
        }
        return nestedDuration;
    }

    public static void collectSqlsInInvocations(List<InvocationSequenceData> invocationSequenceDataList, List<SqlStatementData> sqlStatementDataList, MutableDouble totalDuration) {
        for (InvocationSequenceData invocationSequenceData : invocationSequenceDataList) {
            if (null != invocationSequenceData.getSqlStatementData()) {
                sqlStatementDataList.add(invocationSequenceData.getSqlStatementData());
                totalDuration.add(invocationSequenceData.getSqlStatementData().getDuration());
            }
            if (!CollectionUtils.isNotEmpty(invocationSequenceDataList)) continue;
            InvocationSequenceDataHelper.collectSqlsInInvocations(invocationSequenceData.getNestedSequences(), sqlStatementDataList, totalDuration);
        }
    }
}

