/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.MethodSensorData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.LoggingData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.communication.data.TimerData;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationSequenceData
extends MethodSensorData {
    private static final long serialVersionUID = 1388734093735447105L;
    private List<InvocationSequenceData> nestedSequences = new ArrayList<InvocationSequenceData>(0);
    private InvocationSequenceData parentSequence;
    private TimerData timerData;
    private SqlStatementData sqlStatementData;
    private List<ExceptionSensorData> exceptionSensorDataObjects;
    private LoggingData loggingData;
    private long position;
    private double duration;
    private double start;
    private double end;
    private long childCount = 0L;
    private Boolean nestedSqlStatements;
    private Boolean nestedExceptions;

    public InvocationSequenceData() {
    }

    public InvocationSequenceData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent, long methodIdent) {
        super(timeStamp, platformIdent, sensorTypeIdent, methodIdent);
    }

    public List<InvocationSequenceData> getNestedSequences() {
        return this.nestedSequences;
    }

    public void setNestedSequences(List<InvocationSequenceData> nestedSequences) {
        this.nestedSequences = nestedSequences;
    }

    public InvocationSequenceData getParentSequence() {
        return this.parentSequence;
    }

    public void setParentSequence(InvocationSequenceData parentSequence) {
        this.parentSequence = parentSequence;
    }

    public TimerData getTimerData() {
        return this.timerData;
    }

    public void setTimerData(TimerData timerData) {
        this.timerData = timerData;
    }

    public SqlStatementData getSqlStatementData() {
        return this.sqlStatementData;
    }

    public void setSqlStatementData(SqlStatementData sqlStatementData) {
        this.sqlStatementData = sqlStatementData;
    }

    public LoggingData getLoggingData() {
        return this.loggingData;
    }

    public void setLoggingData(LoggingData loggingData) {
        this.loggingData = loggingData;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public long getPosition() {
        return this.position;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public double getDuration() {
        return this.duration;
    }

    public double getStart() {
        return this.start;
    }

    public void setStart(double start) {
        this.start = start;
    }

    public double getEnd() {
        return this.end;
    }

    public List<ExceptionSensorData> getExceptionSensorDataObjects() {
        return this.exceptionSensorDataObjects;
    }

    public void setExceptionSensorDataObjects(List<ExceptionSensorData> exceptionSensorDataObjects) {
        this.exceptionSensorDataObjects = exceptionSensorDataObjects;
    }

    public void addExceptionSensorData(ExceptionSensorData data) {
        if (null == this.exceptionSensorDataObjects) {
            this.exceptionSensorDataObjects = new ArrayList<ExceptionSensorData>();
        }
        this.exceptionSensorDataObjects.add(data);
    }

    public void setEnd(double end) {
        this.end = end;
    }

    public void setChildCount(long childCount) {
        this.childCount = childCount;
    }

    public long getChildCount() {
        return this.childCount;
    }

    public Boolean isNestedSqlStatements() {
        return this.nestedSqlStatements;
    }

    public void setNestedSqlStatements(Boolean nestedSqlStatements) {
        this.nestedSqlStatements = nestedSqlStatements;
    }

    public Boolean isNestedExceptions() {
        return this.nestedExceptions;
    }

    public void setNestedExceptions(Boolean nestedExceptions) {
        this.nestedExceptions = nestedExceptions;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.exceptionSensorDataObjects == null ? 0 : this.exceptionSensorDataObjects.hashCode());
        result = 31 * result + (this.sqlStatementData == null ? 0 : this.sqlStatementData.hashCode());
        result = 31 * result + (this.timerData == null ? 0 : this.timerData.hashCode());
        result = 31 * result + (this.loggingData == null ? 0 : this.loggingData.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InvocationSequenceData other = (InvocationSequenceData)obj;
        if (this.exceptionSensorDataObjects == null ? other.exceptionSensorDataObjects != null : !this.exceptionSensorDataObjects.equals(other.exceptionSensorDataObjects)) {
            return false;
        }
        if (this.sqlStatementData == null ? other.sqlStatementData != null : !this.sqlStatementData.equals(other.sqlStatementData)) {
            return false;
        }
        if (this.timerData == null ? other.timerData != null : !this.timerData.equals(other.timerData)) {
            return false;
        }
        return !(this.loggingData == null ? other.loggingData != null : !this.loggingData.equals(other.loggingData));
    }

    @Override
    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = super.getObjectSize(objectSizes, doAlign);
        size += objectSizes.getPrimitiveTypesSize(8, 0, 0, 0, 2, 3);
        size += objectSizes.getSizeOf(this.timerData);
        size += objectSizes.getSizeOf(this.loggingData);
        size += objectSizes.getSizeOf(this.sqlStatementData);
        if (this.nestedSequences instanceof ArrayList) {
            size += objectSizes.getSizeOf(this.nestedSequences, 0);
            for (InvocationSequenceData invocationSequenceData : this.nestedSequences) {
                size += objectSizes.getSizeOf(invocationSequenceData);
            }
        }
        if (null != this.exceptionSensorDataObjects) {
            size += objectSizes.getSizeOf(this.exceptionSensorDataObjects);
            for (ExceptionSensorData exceptionSensorData : this.exceptionSensorDataObjects) {
                size += objectSizes.getSizeOf(exceptionSensorData);
            }
        }
        if (null != this.nestedSqlStatements) {
            size += objectSizes.getSizeOfBooleanObject();
        }
        if (null != this.nestedExceptions) {
            size += objectSizes.getSizeOfBooleanObject();
        }
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }

    public InvocationSequenceData getClonedInvocationSequence() {
        InvocationSequenceData clone = new InvocationSequenceData(this.getTimeStamp(), this.getPlatformIdent(), this.getSensorTypeIdent(), this.getMethodIdent());
        clone.setId(this.getId());
        clone.setChildCount(this.getChildCount());
        clone.setDuration(this.getDuration());
        clone.setEnd(this.getEnd());
        clone.setNestedSequences(Collections.<InvocationSequenceData>emptyList());
        clone.setParameterContentData(this.getParameterContentData());
        clone.setParentSequence(this.getParentSequence());
        clone.setPosition(this.getPosition());
        clone.setSqlStatementData(this.getSqlStatementData());
        clone.setTimerData(this.getTimerData());
        clone.setExceptionSensorDataObjects(this.getExceptionSensorDataObjects());
        clone.setStart(this.getStart());
        clone.setNestedSqlStatements(this.isNestedSqlStatements());
        clone.setNestedExceptions(this.isNestedExceptions());
        clone.setLoggingData(this.getLoggingData());
        return clone;
    }
}

