/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.Sizeable;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;

@Entity
@Table(indexes={@Index(name="uri_idx", columnList="uri"), @Index(name="tag_idx", columnList="inspectItTaggingHeaderValue")})
public class HttpInfo
implements Sizeable,
Serializable {
    private static final long serialVersionUID = -6649412114779075805L;
    public static final String UNDEFINED = "n.a.";
    private static final int MAX_URI_SIZE = 1000;
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE)
    private long id;
    @Column(length=1000)
    private String uri = "n.a.";
    private String requestMethod = "n.a.";
    private String inspectItTaggingHeaderValue;

    public HttpInfo() {
    }

    public HttpInfo(String uri, String requestMethod, String inspectItTaggingHeaderValue) {
        this.uri = uri;
        this.requestMethod = requestMethod;
        this.inspectItTaggingHeaderValue = inspectItTaggingHeaderValue;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean isUriDefined() {
        return this.uri != null && !UNDEFINED.equals(this.uri);
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        if (null != uri) {
            this.uri = uri.length() > 1000 ? uri.substring(0, 1000) : uri;
        }
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public boolean hasInspectItTaggingHeader() {
        return null != this.getInspectItTaggingHeaderValue();
    }

    public String getInspectItTaggingHeaderValue() {
        return this.inspectItTaggingHeaderValue;
    }

    public void setInspectItTaggingHeaderValue(String inspectItTaggingHeaderValue) {
        this.inspectItTaggingHeaderValue = inspectItTaggingHeaderValue;
    }

    public long getObjectSize(IObjectSizes objectSizes) {
        return this.getObjectSize(objectSizes, true);
    }

    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = objectSizes.getSizeOfObjectHeader();
        size += objectSizes.getPrimitiveTypesSize(3, 0, 0, 0, 1, 0);
        size += objectSizes.getSizeOf(this.uri, this.requestMethod, this.inspectItTaggingHeaderValue);
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.inspectItTaggingHeaderValue == null ? 0 : this.inspectItTaggingHeaderValue.hashCode());
        result = 31 * result + (this.requestMethod == null ? 0 : this.requestMethod.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpInfo other = (HttpInfo)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.inspectItTaggingHeaderValue == null ? other.inspectItTaggingHeaderValue != null : !this.inspectItTaggingHeaderValue.equals(other.inspectItTaggingHeaderValue)) {
            return false;
        }
        if (this.requestMethod == null ? other.requestMethod != null : !this.requestMethod.equals(other.requestMethod)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

