/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.ExceptionEvent;
import info.novatec.inspectit.communication.IIdsAwareAggregatedData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatedExceptionSensorData
extends ExceptionSensorData
implements IIdsAwareAggregatedData<ExceptionSensorData> {
    private static final long serialVersionUID = -7258567013769154129L;
    private long created;
    private long passed;
    private long handled;
    private Map<Long, Boolean> aggregatedIds = new ConcurrentHashMap<Long, Boolean>(16, 0.75f, 4);

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public long getPassed() {
        return this.passed;
    }

    public void setPassed(long passed) {
        this.passed = passed;
    }

    public long getHandled() {
        return this.handled;
    }

    public void setHandled(long handled) {
        this.handled = handled;
    }

    @Override
    public double getInvocationAffiliationPercentage() {
        return (double)this.getObjectsInInvocationsCount() / (double)this.created;
    }

    public void aggregateExceptionData(ExceptionSensorData exceptionData) {
        if (exceptionData.getExceptionEvent() == ExceptionEvent.CREATED) {
            ++this.created;
        } else if (exceptionData.getExceptionEvent() == ExceptionEvent.PASSED) {
            ++this.passed;
        } else if (exceptionData.getExceptionEvent() == ExceptionEvent.HANDLED) {
            ++this.handled;
        }
        if (null != exceptionData.getInvocationParentsIdSet()) {
            for (Long parentId : exceptionData.getInvocationParentsIdSet()) {
                this.addInvocationParentId(parentId);
            }
        }
        if (0L != exceptionData.getId()) {
            this.aggregatedIds.put(exceptionData.getId(), Boolean.TRUE);
        }
    }

    public void aggregateExceptionData(AggregatedExceptionSensorData aggregatedExceptionData) {
        if (null != aggregatedExceptionData.getAggregatedIds()) {
            for (Long id : aggregatedExceptionData.getAggregatedIds()) {
                this.aggregatedIds.put(id, Boolean.TRUE);
            }
        }
        super.aggregateInvocationAwareData(aggregatedExceptionData);
        this.setCreated(this.getCreated() + aggregatedExceptionData.getCreated());
        this.setHandled(this.getHandled() + aggregatedExceptionData.getHandled());
        this.setPassed(this.getPassed() + aggregatedExceptionData.getPassed());
    }

    @Override
    public void aggregate(ExceptionSensorData data) {
        if (data instanceof AggregatedExceptionSensorData) {
            this.aggregateExceptionData((AggregatedExceptionSensorData)data);
        } else {
            this.aggregateExceptionData(data);
        }
    }

    @Override
    public Collection<Long> getAggregatedIds() {
        return this.aggregatedIds.keySet();
    }

    @Override
    public void clearAggregatedIds() {
        this.aggregatedIds.clear();
    }

    @Override
    public ExceptionSensorData getData() {
        return this;
    }

    @Override
    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = super.getObjectSize(objectSizes, false);
        size += objectSizes.getPrimitiveTypesSize(1, 0, 0, 0, 3, 0);
        if (null != this.aggregatedIds) {
            size += objectSizes.getSizeOfConcurrentHashMap(this.aggregatedIds.size(), 4);
            size += (long)this.aggregatedIds.size() * objectSizes.getSizeOfLongObject();
        }
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.aggregatedIds == null ? 0 : this.aggregatedIds.hashCode());
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + (int)(this.handled ^ this.handled >>> 32);
        result = 31 * result + (int)(this.passed ^ this.passed >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggregatedExceptionSensorData other = (AggregatedExceptionSensorData)obj;
        if (this.aggregatedIds == null ? other.aggregatedIds != null : !this.aggregatedIds.equals(other.aggregatedIds)) {
            return false;
        }
        if (this.created != other.created) {
            return false;
        }
        if (this.handled != other.handled) {
            return false;
        }
        return this.passed == other.passed;
    }
}

