/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.comparator;

import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.communication.comparator.IDataComparator;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SqlStatementDataComparatorEnum implements IDataComparator<SqlStatementData>,
Comparator<SqlStatementData>
{
    IS_PREPARED_STATEMENT,
    SQL,
    PARAMETERS,
    SQL_AND_PARAMETERS,
    DATABASE_NAME,
    DATABASE_VERSION,
    DATABASE_URL;


    @Override
    public int compare(SqlStatementData o1, SqlStatementData o2, ICachedDataService cachedDataService) {
        return this.compare(o1, o2);
    }

    @Override
    public int compare(SqlStatementData o1, SqlStatementData o2) {
        switch (this) {
            case IS_PREPARED_STATEMENT: {
                return Boolean.valueOf(o1.isPreparedStatement()).compareTo(o2.isPreparedStatement());
            }
            case SQL: {
                return ObjectUtils.compare(o1.getSql(), o2.getSql());
            }
            case DATABASE_NAME: {
                return ObjectUtils.compare(o1.getDatabaseProductName(), o2.getDatabaseProductName());
            }
            case DATABASE_VERSION: {
                return ObjectUtils.compare(o1.getDatabaseProductVersion(), o2.getDatabaseProductVersion());
            }
            case DATABASE_URL: {
                return ObjectUtils.compare(o1.getDatabaseUrl(), o2.getDatabaseUrl());
            }
            case PARAMETERS: {
                List<String> parameterList1 = o1.getParameterValues();
                List<String> parameterList2 = o2.getParameterValues();
                return ObjectUtils.compare(parameterList1, parameterList2);
            }
            case SQL_AND_PARAMETERS: {
                int result = SQL.compare(o1, o2);
                if (0 != result) {
                    return result;
                }
                return PARAMETERS.compare(o1, o2);
            }
        }
        return 0;
    }
}

