/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.comparator;

import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.communication.MethodSensorData;
import info.novatec.inspectit.communication.comparator.IDataComparator;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MethodSensorDataComparatorEnum implements IDataComparator<MethodSensorData>,
Comparator<MethodIdent>
{
    PACKAGE,
    CLASS,
    METHOD;


    @Override
    public int compare(MethodSensorData o1, MethodSensorData o2, ICachedDataService cachedDataService) {
        if (null == cachedDataService) {
            return 0;
        }
        MethodIdent methodIdent1 = cachedDataService.getMethodIdentForId(o1.getMethodIdent());
        MethodIdent methodIdent2 = cachedDataService.getMethodIdentForId(o2.getMethodIdent());
        if (null != methodIdent1 && null != methodIdent2) {
            return this.compare(methodIdent1, methodIdent2);
        }
        return 0;
    }

    @Override
    public int compare(MethodIdent methodIdent1, MethodIdent methodIdent2) {
        switch (this) {
            case PACKAGE: {
                return ObjectUtils.compare(methodIdent1.getPackageName(), methodIdent2.getPackageName());
            }
            case CLASS: {
                return ObjectUtils.compare(methodIdent1.getClassName(), methodIdent2.getClassName());
            }
            case METHOD: {
                int result = ObjectUtils.compare(methodIdent1.getMethodName(), methodIdent2.getMethodName());
                if (0 != result) {
                    return result;
                }
                List<String> parameterList1 = methodIdent1.getParameters();
                List<String> parameterList2 = methodIdent2.getParameters();
                return ObjectUtils.compare(parameterList1, parameterList2);
            }
        }
        return 0;
    }
}

