/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.comparator;

import info.novatec.inspectit.cmr.model.JmxDefinitionDataIdent;
import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.communication.comparator.IDataComparator;
import info.novatec.inspectit.communication.data.JmxSensorValueData;
import org.apache.commons.lang.BooleanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JmxDataComparatorEnum implements IDataComparator<JmxSensorValueData>
{
    CHARTING,
    DERIVED_DOMAINNAME,
    DERIVED_TYPENAME,
    OBJECTNAME,
    ATTRIBUTENAME,
    VALUE,
    READABLE,
    WRITABLE,
    IS_ISGETTER;


    @Override
    public int compare(JmxSensorValueData o1, JmxSensorValueData o2, ICachedDataService cachedDataService) {
        switch (this) {
            case VALUE: {
                return o1.getValue().compareTo(o2.getValue());
            }
            case CHARTING: {
                return BooleanUtils.toBooleanObject((boolean)o1.isBooleanOrNumeric()).compareTo(o2.isBooleanOrNumeric());
            }
        }
        if (null == cachedDataService) {
            return 0;
        }
        JmxDefinitionDataIdent jmxIdent1 = cachedDataService.getJmxDefinitionDataIdentForId(o1.getJmxSensorDefinitionDataIdentId());
        JmxDefinitionDataIdent jmxIdent2 = cachedDataService.getJmxDefinitionDataIdentForId(o2.getJmxSensorDefinitionDataIdentId());
        switch (this) {
            case ATTRIBUTENAME: {
                return jmxIdent1.getmBeanAttributeName().compareTo(jmxIdent2.getmBeanAttributeName());
            }
            case DERIVED_DOMAINNAME: {
                return jmxIdent1.getDerivedDomainName().compareTo(jmxIdent2.getDerivedDomainName());
            }
            case DERIVED_TYPENAME: {
                return jmxIdent1.getDerivedTypeName().compareTo(jmxIdent2.getDerivedTypeName());
            }
            case OBJECTNAME: {
                return jmxIdent1.getmBeanObjectName().compareTo(jmxIdent2.getmBeanObjectName());
            }
            case READABLE: {
                return jmxIdent1.getmBeanAttributeIsReadable().compareTo(jmxIdent2.getmBeanAttributeIsReadable());
            }
            case WRITABLE: {
                return jmxIdent1.getmBeanAttributeIsWritable().compareTo(jmxIdent2.getmBeanAttributeIsWritable());
            }
            case IS_ISGETTER: {
                return jmxIdent1.getmBeanAttributeIsIs().compareTo(jmxIdent2.getmBeanAttributeIsIs());
            }
        }
        return 0;
    }
}

