/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.model;

import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.model.MethodSensorTypeIdent;
import java.io.Serializable;
import java.sql.Timestamp;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Table(indexes={@Index(name="method_ident_to_sensor_type_idx", columnList="methodIdent"), @Index(name="method_ident_to_sensor_type_idx", columnList="methodSensorTypeIdent")})
@NamedQuery(name="MethodIdentToSensorType.findForMethodIdAndMethodSensorTypeId", query="SELECT m from MethodIdentToSensorType m JOIN m.methodIdent mi JOIN m.methodSensorTypeIdent ms WHERE mi.id=:methodIdentId AND ms.id=:methodSensorTypeIdentId")
@Entity
public class MethodIdentToSensorType
implements Serializable {
    private static final long serialVersionUID = -3767712432753232084L;
    public static final String FIND_FOR_METHOD_ID_AND_METOHD_SENSOR_TYPE_ID = "MethodIdentToSensorType.findForMethodIdAndMethodSensorTypeId";
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="METHOD_SENSOR_SEQUENCE")
    @SequenceGenerator(name="METHOD_SENSOR_SEQUENCE", sequenceName="METHOD_SENSOR_SEQUENCE")
    private Long id;
    @NotNull
    @ManyToOne
    @JoinColumn(name="methodIdent")
    private MethodIdent methodIdent;
    @NotNull
    @ManyToOne
    @JoinColumn(name="methodSensorTypeIdent")
    private MethodSensorTypeIdent methodSensorTypeIdent;
    @NotNull
    private Timestamp timestamp;

    public MethodIdentToSensorType() {
    }

    public MethodIdentToSensorType(MethodIdent methodIdent, MethodSensorTypeIdent methodSensorTypeIdent, Timestamp timestamp) {
        this.methodIdent = methodIdent;
        this.methodSensorTypeIdent = methodSensorTypeIdent;
        this.timestamp = timestamp;
    }

    public boolean isActive() {
        return this.timestamp.after(this.methodIdent.getPlatformIdent().getTimeStamp());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public MethodIdent getMethodIdent() {
        return this.methodIdent;
    }

    public void setMethodIdent(MethodIdent methodIdent) {
        this.methodIdent = methodIdent;
    }

    public MethodSensorTypeIdent getMethodSensorTypeIdent() {
        return this.methodSensorTypeIdent;
    }

    public void setMethodSensorTypeIdent(MethodSensorTypeIdent methodSensorTypeIdent) {
        this.methodSensorTypeIdent = methodSensorTypeIdent;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.methodIdent == null ? 0 : this.methodIdent.hashCode());
        result = 31 * result + (this.methodSensorTypeIdent == null ? 0 : this.methodSensorTypeIdent.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodIdentToSensorType other = (MethodIdentToSensorType)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.methodIdent == null ? other.methodIdent != null : !this.methodIdent.equals(other.methodIdent)) {
            return false;
        }
        if (this.methodSensorTypeIdent == null ? other.methodSensorTypeIdent != null : !this.methodSensorTypeIdent.equals(other.methodSensorTypeIdent)) {
            return false;
        }
        return !(this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp));
    }
}

