/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.cglib;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CGLibProxySerializer
extends Serializer<Object> {
    private static String DEFAULT_NAMING_MARKER = "$$EnhancerByCGLIB$$";

    public static boolean canSerialize(Class<?> cls) {
        return Enhancer.isEnhanced(cls) && cls.getName().indexOf(DEFAULT_NAMING_MARKER) > 0;
    }

    public Object read(Kryo kryo, Input input, Class<Object> type) {
        Class superclass = kryo.readClass(input).getType();
        Class[] interfaces = (Class[])kryo.readObject(input, Class[].class);
        Callback[] callbacks = (Callback[])kryo.readObject(input, Callback[].class);
        return this.createProxy(superclass, interfaces, callbacks);
    }

    public void write(Kryo kryo, Output output, Object obj) {
        kryo.writeClass(output, obj.getClass().getSuperclass());
        kryo.writeObject(output, obj.getClass().getInterfaces());
        kryo.writeObject(output, (Object)((Factory)obj).getCallbacks());
    }

    private Object createProxy(Class<?> targetClass, Class<?>[] interfaces, Callback[] callbacks) {
        Enhancer e = new Enhancer();
        e.setInterfaces((Class[])interfaces);
        e.setSuperclass(targetClass);
        e.setCallbacks(callbacks);
        return e.create();
    }

    public static interface CGLibProxyMarker {
    }
}

