/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdkProxySerializer
extends Serializer<Object> {
    public Object read(Kryo kryo, Input input, Class<Object> type) {
        InvocationHandler invocationHandler = (InvocationHandler)kryo.readClassAndObject(input);
        Class[] interfaces = (Class[])kryo.readObject(input, Class[].class);
        ClassLoader classLoader = kryo.getClassLoader();
        try {
            return Proxy.newProxyInstance(classLoader, interfaces, invocationHandler);
        }
        catch (RuntimeException e) {
            System.err.println(((Object)((Object)this)).getClass().getName() + ".read:\n" + "Could not create proxy using classLoader " + classLoader + "," + " have invocationhandler.classloader: " + invocationHandler.getClass().getClassLoader() + " have contextclassloader: " + Thread.currentThread().getContextClassLoader());
            throw e;
        }
    }

    public void write(Kryo kryo, Output output, Object obj) {
        kryo.writeClassAndObject(output, (Object)Proxy.getInvocationHandler(obj));
        kryo.writeObject(output, obj.getClass().getInterfaces());
    }
}

