/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.storage;

import info.novatec.inspectit.cmr.dao.impl.PlatformIdentDaoImpl;
import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.storage.StorageFileType;
import info.novatec.inspectit.storage.StorageWriter;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.ObjectStorageLabel;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import info.novatec.inspectit.storage.label.type.impl.DataTimeFrameLabelType;
import info.novatec.inspectit.util.TimeFrame;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="cmrStorageWriter")
@Scope(value="prototype")
@Lazy
public class CmrStorageWriter
extends StorageWriter {
    @Log
    Logger log;
    private Set<Long> involvedAgentsSet = new HashSet<Long>();
    private AtomicLong oldestDataTimestamp = new AtomicLong(Long.MAX_VALUE);
    private AtomicLong newestDataTimestamp = new AtomicLong(0L);
    @Autowired
    private PlatformIdentDaoImpl platformIdentDao;

    public Future<Void> write(DefaultData defaultData) {
        Future future = super.write(defaultData);
        this.postWriteOperations(defaultData);
        return future;
    }

    public Future<Void> write(DefaultData defaultData, Map<?, ?> kryoPreferences) {
        Future future = super.write(defaultData, kryoPreferences);
        this.postWriteOperations(defaultData);
        return future;
    }

    protected void writeAgentData() throws IOException {
        List<PlatformIdent> involvedPlatformIdents = this.platformIdentDao.findAllInitialized(this.involvedAgentsSet);
        for (PlatformIdent agent : involvedPlatformIdents) {
            super.writeNonDefaultDataObject((Object)agent, agent.getId() + StorageFileType.AGENT_FILE.getExtension());
        }
    }

    public synchronized void finalizeWrite() {
        try {
            this.writeAgentData();
        }
        catch (IOException e) {
            this.log.error("Exception trying to write agent data to disk.", (Throwable)e);
        }
        super.finalizeWrite();
        if (this.newestDataTimestamp.get() > 0L && this.oldestDataTimestamp.get() < Long.MAX_VALUE) {
            TimeFrame timeFrame = new TimeFrame(new Date(this.oldestDataTimestamp.get()), new Date(this.newestDataTimestamp.get()));
            ObjectStorageLabel timeframeLabel = new ObjectStorageLabel((Comparable)timeFrame, (AbstractStorageLabelType)new DataTimeFrameLabelType());
            this.getStorageData().addLabel((AbstractStorageLabel)timeframeLabel, true);
        }
    }

    private void postWriteOperations(DefaultData defaultData) {
        long newestData;
        long oldestData;
        this.involvedAgentsSet.add(defaultData.getPlatformIdent());
        while ((oldestData = this.oldestDataTimestamp.get()) > defaultData.getTimeStamp().getTime() && !this.oldestDataTimestamp.compareAndSet(oldestData, defaultData.getTimeStamp().getTime())) {
        }
        while ((newestData = this.newestDataTimestamp.get()) < defaultData.getTimeStamp().getTime() && !this.newestDataTimestamp.compareAndSet(newestData, defaultData.getTimeStamp().getTime())) {
        }
    }

    public void setPlatformIdentDao(PlatformIdentDaoImpl platformIdentDao) {
        this.platformIdentDao = platformIdentDao;
    }
}

