/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.spring.aop;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import info.novatec.inspectit.cmr.spring.aop.MethodLog;
import info.novatec.inspectit.cmr.util.Converter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class MethodLogInterceptor {
    private static final String DURATION_THRESHOLD_MSG = "WARNING: Duration threshold (%s ms) exceeded for method '{}': {} ms";
    private static final String DURATION_THRESHOLD_MSG_W_TRACE = "    WARNING: Duration threshold ({} ms) exceeded for method '{}': {} ms";
    private static final String TIME_LOG_FORMAT = "'{}' duration: {} ms";
    private static final String TIME_LOG_FORMAT_W_TRACE = "    '{}' duration: {} ms";
    private static final String TRACE_ENTER_FORMAT = "--> {}#{}()";
    private static final String TRACE_EXIT_FORMAT = "<-- {}#{}()";
    private static final String SPLIT_METHOD_REGEX = "(?=\\p{Lu})";
    private static final Pattern SPLIT_METHOD_PATTERN = Pattern.compile("(?=\\p{Lu})");
    private static final Map<MethodLog.Level, Level> LEVELS = new HashMap<MethodLog.Level, Level>(8, 1.0f);

    @Around(value="@annotation(info.novatec.inspectit.cmr.spring.aop.MethodLog) && @annotation(methodLog)")
    public Object doMethodLog(ProceedingJoinPoint joinPoint, MethodLog methodLog) throws Throwable {
        String formatString;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Logger logger = (Logger)LoggerFactory.getLogger(joinPoint.getTarget().getClass());
        Level timeLogLevel = LEVELS.get((Object)methodLog.timeLogLevel());
        Level traceLogLevel = LEVELS.get((Object)methodLog.traceLogLevel());
        if (logger.isEnabledFor(traceLogLevel)) {
            logger.log(null, signature.getDeclaringType().getName(), 0, TRACE_ENTER_FORMAT, new Object[]{signature.getDeclaringType().getName(), signature.getName()}, null);
        }
        long startTime = System.nanoTime();
        Object object = joinPoint.proceed();
        long endTime = System.nanoTime();
        double duration = Converter.nanoToMilliseconds(endTime - startTime);
        String methodName = null;
        if (logger.isEnabledFor(timeLogLevel)) {
            methodName = this.convertMethodName(signature.getName());
            formatString = logger.isEnabledFor(traceLogLevel) ? TIME_LOG_FORMAT_W_TRACE : TIME_LOG_FORMAT;
            logger.log(null, signature.getDeclaringType().getName(), 30, formatString, new Object[]{methodName, duration}, null);
        }
        if (-1L != methodLog.durationLimit() && duration > (double)methodLog.durationLimit()) {
            if (null == methodName) {
                methodName = this.convertMethodName(signature.getName());
            }
            formatString = logger.isEnabledFor(traceLogLevel) ? DURATION_THRESHOLD_MSG_W_TRACE : DURATION_THRESHOLD_MSG;
            logger.log(null, signature.getDeclaringType().getName(), 30, formatString, new Object[]{methodLog.durationLimit(), methodName, duration}, null);
        }
        if (logger.isEnabledFor(traceLogLevel)) {
            logger.log(null, signature.getDeclaringType().getName(), 0, TRACE_EXIT_FORMAT, new Object[]{signature.getDeclaringType().getName(), signature.getName()}, null);
        }
        return object;
    }

    private String convertMethodName(String name) {
        String[] r = SPLIT_METHOD_PATTERN.split(name, 0);
        StringBuilder builder = new StringBuilder();
        String first = r[0];
        builder.append(Character.toUpperCase(first.charAt(0)));
        builder.append(first.substring(1));
        for (int i = 1; i < r.length; ++i) {
            builder.append(' ');
            builder.append(r[i]);
        }
        return builder.toString();
    }

    static {
        LEVELS.put(MethodLog.Level.ALL, Level.ALL);
        LEVELS.put(MethodLog.Level.DEBUG, Level.DEBUG);
        LEVELS.put(MethodLog.Level.ERROR, Level.ERROR);
        LEVELS.put(MethodLog.Level.INFO, Level.INFO);
        LEVELS.put(MethodLog.Level.OFF, Level.OFF);
        LEVELS.put(MethodLog.Level.TRACE, Level.TRACE);
        LEVELS.put(MethodLog.Level.WARN, Level.WARN);
    }
}

