/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.spring.aop;

import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.exception.RemoteException;
import info.novatec.inspectit.spring.logger.Log;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ExceptionInterceptor {
    @Log
    Logger log;
    private static Field throwableCauseField;

    @Around(value="execution(* info.novatec.inspectit.cmr.service.*.*(..))")
    public Object logServiceException(ProceedingJoinPoint jp) throws Exception {
        try {
            return jp.proceed();
        }
        catch (BusinessException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("BusinessException thrown in the service method " + jp.getSignature() + " executed with following parameters: " + Arrays.toString(jp.getArgs()) + ".", (Throwable)e);
            }
            e.setServiceMethodSignature(jp.getSignature().toString());
            throw e;
        }
        catch (RemoteException e) {
            this.log.warn("Exception thrown in the service method " + jp.getSignature() + " executed with following parameters: " + Arrays.toString(jp.getArgs()) + ". Original exception class is: " + e.getOriginalExceptionClass(), (Throwable)e);
            e.setServiceMethodSignature(jp.getSignature().toString());
            throw e;
        }
        catch (Throwable t) {
            this.log.warn("Exception thrown in the service method " + jp.getSignature() + " executed with following parameters: " + Arrays.toString(jp.getArgs()) + ".", t);
            RemoteException transformException = ExceptionInterceptor.transformException(t, new ArrayList<Throwable>());
            transformException.setServiceMethodSignature(jp.getSignature().toString());
            throw transformException;
        }
    }

    public static RemoteException transformException(Throwable throwable) {
        try {
            return ExceptionInterceptor.transformException(throwable, new ArrayList<Throwable>());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to transform exception to the RemoteException. Check nested Exception.", e);
        }
    }

    private static RemoteException transformException(Throwable throwable, List<Throwable> visitedException) throws IllegalAccessException {
        if (throwable == null || !visitedException.add(throwable) || throwable instanceof RemoteException) {
            return null;
        }
        RemoteException transformedException = new RemoteException(throwable);
        throwableCauseField.set((Object)transformedException, (Object)ExceptionInterceptor.transformException(throwable.getCause(), visitedException));
        return transformedException;
    }

    static {
        try {
            throwableCauseField = Throwable.class.getDeclaredField("cause");
            throwableCauseField.setAccessible(true);
        }
        catch (Exception e) {
            throw new BeanInitializationException("Count not initialize " + ExceptionInterceptor.class.getName() + ". Check nested Exception.", (Throwable)e);
        }
    }
}

