/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.service.rest;

import info.novatec.inspectit.cmr.service.ICmrManagementService;
import info.novatec.inspectit.cmr.service.rest.error.JsonError;
import info.novatec.inspectit.communication.data.cmr.CmrStatusData;
import info.novatec.inspectit.version.VersionService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/cmr"})
public class CmrRestfulService {
    @Autowired
    private VersionService versionService;
    @Autowired
    private ICmrManagementService cmrManagementService;

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleAllException(Exception exception) {
        return new JsonError(exception).asModelAndView();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"version"})
    @ResponseBody
    public String getVersion() throws IOException {
        return this.versionService.getVersionAsString();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"status-data"})
    @ResponseBody
    public CmrStatusData getStatusData() {
        return this.cmrManagementService.getCmrStatusData();
    }
}

