/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.service;

import info.novatec.inspectit.cmr.cache.IBuffer;
import info.novatec.inspectit.cmr.property.PropertyManager;
import info.novatec.inspectit.cmr.property.configuration.PropertySection;
import info.novatec.inspectit.cmr.property.update.configuration.ConfigurationUpdate;
import info.novatec.inspectit.cmr.service.ICmrManagementService;
import info.novatec.inspectit.cmr.spring.aop.MethodLog;
import info.novatec.inspectit.cmr.util.ShutdownService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.cmr.CmrStatusData;
import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.storage.StorageManager;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.mutable.MutableLong;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CmrManagementService
implements ICmrManagementService {
    private static final String DATABASE_FOLDER = "db";
    @Log
    Logger log;
    @Autowired
    private IBuffer<DefaultData> buffer;
    @Autowired
    private StorageManager storageManager;
    @Autowired
    private PropertyManager propertyManager;
    private int droppedDataCount = 0;
    @Autowired
    private ShutdownService shutdownService;
    private long timeStarted;
    private Date dateStarted;

    public void restart() {
        this.shutdownService.restart();
    }

    public void shutdown() {
        this.shutdownService.shutdown();
    }

    @MethodLog
    public void clearBuffer() {
        this.buffer.clearAll();
    }

    @MethodLog
    public CmrStatusData getCmrStatusData() {
        CmrStatusData cmrStatusData = new CmrStatusData();
        cmrStatusData.setCurrentBufferSize(this.buffer.getCurrentSize());
        cmrStatusData.setMaxBufferSize(this.buffer.getMaxSize());
        cmrStatusData.setBufferOldestElement(this.buffer.getOldestElement());
        cmrStatusData.setBufferNewestElement(this.buffer.getNewestElement());
        cmrStatusData.setStorageDataSpaceLeft(this.storageManager.getBytesHardDriveOccupancyLeft());
        cmrStatusData.setStorageMaxDataSpace(this.storageManager.getMaxBytesHardDriveOccupancy());
        cmrStatusData.setWarnSpaceLeftActive(this.storageManager.isSpaceWarnActive());
        cmrStatusData.setCanWriteMore(this.storageManager.canWriteMore());
        cmrStatusData.setUpTime(System.currentTimeMillis() - this.timeStarted);
        cmrStatusData.setDateStarted(this.dateStarted);
        cmrStatusData.setDatabaseSize(this.getDatabaseSize());
        return cmrStatusData;
    }

    public void addDroppedDataCount(int count) {
        this.droppedDataCount += count;
    }

    public int getDroppedDataCount() {
        return this.droppedDataCount;
    }

    public Collection<PropertySection> getConfigurationPropertySections() {
        return this.propertyManager.getConfigurationPropertySections();
    }

    public void updateConfiguration(ConfigurationUpdate configurationUpdate, boolean executeRestart) throws Exception {
        this.propertyManager.updateConfiguration(configurationUpdate, executeRestart);
    }

    private Long getDatabaseSize() {
        Path databaseFolder = Paths.get(DATABASE_FOLDER, new String[0]);
        if (Files.notExists(databaseFolder, new LinkOption[0]) || !Files.isDirectory(databaseFolder, new LinkOption[0])) {
            return null;
        }
        final MutableLong size = new MutableLong();
        try {
            Files.walkFileTree(databaseFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    size.add(attrs.size());
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            return null;
        }
        return size.longValue();
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        this.timeStarted = System.currentTimeMillis();
        this.dateStarted = new Date(this.timeStarted);
        if (this.log.isInfoEnabled()) {
            this.log.info("|-CMR Management Service active...");
        }
    }
}

