/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.dao.impl;

import info.novatec.inspectit.cmr.dao.StorageDataDao;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.SystemSensorData;
import info.novatec.inspectit.communication.data.SystemInformationData;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.exception.IErrorCode;
import info.novatec.inspectit.exception.enumeration.StorageErrorCodeEnum;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.buffer.IBufferTreeComponent;
import info.novatec.inspectit.indexing.impl.IndexQuery;
import info.novatec.inspectit.indexing.query.provider.impl.IndexQueryProvider;
import info.novatec.inspectit.indexing.restriction.impl.IndexQueryRestrictionFactory;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.StringStorageLabel;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import info.novatec.inspectit.storage.label.type.impl.AssigneeLabelType;
import info.novatec.inspectit.storage.label.type.impl.RatingLabelType;
import info.novatec.inspectit.storage.label.type.impl.StatusLabelType;
import info.novatec.inspectit.storage.label.type.impl.UseCaseLabelType;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Repository
public class StorageDataDaoImpl
implements StorageDataDao {
    @Autowired
    private IndexQueryProvider indexQueryProvider;
    @Autowired
    private IBufferTreeComponent<DefaultData> indexingTree;
    @PersistenceContext
    private EntityManager entityManager;
    private TransactionTemplate tt;

    @Autowired
    public StorageDataDaoImpl(PlatformTransactionManager transactionManager) {
        this.tt = new TransactionTemplate(transactionManager);
    }

    @Override
    public boolean saveLabel(AbstractStorageLabel<?> label) {
        List<?> exampleFind;
        if (label.getStorageLabelType().isValueReusable() && !(exampleFind = this.loadAll(label.getClass())).contains(label)) {
            AbstractStorageLabelType labelType = label.getStorageLabelType();
            if (null == labelType) {
                return false;
            }
            if (labelType.getId() == 0 && !labelType.isMultiType()) {
                return false;
            }
            this.entityManager.persist(label);
            return true;
        }
        return false;
    }

    @Override
    public void removeLabel(AbstractStorageLabel<?> label) {
        if (label.getStorageLabelType().isValueReusable()) {
            this.entityManager.remove(label);
        }
    }

    @Override
    public void removeLabels(Collection<AbstractStorageLabel<?>> labels) {
        for (AbstractStorageLabel<?> label : labels) {
            this.removeLabel(label);
        }
    }

    @Override
    public List<AbstractStorageLabel<?>> getAllLabels() {
        Query query = this.entityManager.createNamedQuery("AbstractStorageLabel.findAll");
        return query.getResultList();
    }

    @Override
    public <E> List<AbstractStorageLabel<E>> getAllLabelsForType(AbstractStorageLabelType<E> labelType) {
        Query query = this.entityManager.createNamedQuery("AbstractStorageLabel.findByLabelType");
        query.setParameter("storageLabelType", labelType);
        return query.getResultList();
    }

    @Override
    public void saveLabelType(AbstractStorageLabelType<?> labelType) {
        if (labelType.isMultiType()) {
            this.entityManager.persist(labelType);
        } else {
            List<?> findByClass = this.loadAll(labelType.getClass());
            if (findByClass.isEmpty()) {
                this.entityManager.persist(labelType);
            }
        }
    }

    @Override
    public void removeLabelType(AbstractStorageLabelType<?> labelType) throws BusinessException {
        if (!this.getAllLabelsForType(labelType).isEmpty()) {
            throw new BusinessException("Delete label type " + labelType.getClass().getSimpleName() + ".", (IErrorCode)StorageErrorCodeEnum.LABEL_TYPE_CAN_NOT_BE_DELETED);
        }
        this.entityManager.remove(labelType);
    }

    @Override
    public <E extends AbstractStorageLabelType<?>> List<E> getLabelTypes(Class<E> labelTypeClass) {
        return this.loadAll(labelTypeClass);
    }

    @Override
    public List<AbstractStorageLabelType<?>> getAllLabelTypes() {
        Query query = this.entityManager.createNamedQuery("AbstractStorageLabelType.findAll");
        return query.getResultList();
    }

    @Override
    public List<DefaultData> getAllDefaultDataForAgent(long platformId, Date fromDate, Date toDate) {
        List<SystemInformationData> systemInformationData;
        List bufferData;
        ArrayList<DefaultData> results = new ArrayList<DefaultData>();
        IndexQuery query = this.indexQueryProvider.createNewIndexQuery();
        query.setPlatformIdent(platformId);
        if (null != fromDate) {
            query.setFromDate(new Timestamp(fromDate.getTime()));
        }
        if (null != toDate) {
            query.setToDate(new Timestamp(toDate.getTime()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(bufferData = this.indexingTree.query((IIndexQuery)query)))) {
            results.addAll(bufferData);
        }
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(SystemSensorData.class);
        Root root = criteria.from(SystemSensorData.class);
        Predicate platformIdPredicate = builder.equal((Expression)root.get("platformIdent"), (Object)platformId);
        Predicate timestampPredicate = null;
        if (null != fromDate && null != toDate) {
            timestampPredicate = builder.between((Expression)root.get("timeStamp"), (Comparable)new Timestamp(fromDate.getTime()), (Comparable)new Timestamp(toDate.getTime()));
        }
        if (null != timestampPredicate) {
            criteria.where(new Predicate[]{platformIdPredicate, timestampPredicate});
        } else {
            criteria.where((Expression)platformIdPredicate);
        }
        List sensorDatas = this.entityManager.createQuery(criteria).getResultList();
        if (CollectionUtils.isNotEmpty((Collection)sensorDatas)) {
            results.addAll(sensorDatas);
        }
        if (CollectionUtils.isNotEmpty(systemInformationData = this.getSystemInformationData(Collections.singletonList(platformId)))) {
            results.addAll(systemInformationData);
        }
        return results;
    }

    @Override
    public List<DefaultData> getDataFromIdList(Collection<Long> elementIds, long platformIdent) {
        IndexQuery query = this.indexQueryProvider.createNewIndexQuery();
        query.addIndexingRestriction(IndexQueryRestrictionFactory.isInCollection((String)"id", elementIds));
        query.setPlatformIdent(platformIdent);
        return this.indexingTree.query((IIndexQuery)query);
    }

    @Override
    public List<SystemInformationData> getSystemInformationData(Collection<Long> agentIds) {
        Query query = this.entityManager.createNamedQuery("SystemInformationData.findLatestForPlatformIds");
        query.setParameter("platformIdents", agentIds);
        return query.getResultList();
    }

    @PostConstruct
    public void init() {
        this.tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                StorageDataDaoImpl.this.createDefaultLabelList();
            }
        });
    }

    private void createDefaultLabelList() {
        StatusLabelType statusLabelType;
        List<StatusLabelType> statusLabelTypeList;
        RatingLabelType ratingLabelType;
        this.saveLabelType((AbstractStorageLabelType<?>)new AssigneeLabelType());
        this.saveLabelType((AbstractStorageLabelType<?>)new UseCaseLabelType());
        List<RatingLabelType> ratingLabelTypeList = this.getLabelTypes(RatingLabelType.class);
        if (CollectionUtils.isNotEmpty(ratingLabelTypeList)) {
            ratingLabelType = ratingLabelTypeList.get(0);
        } else {
            ratingLabelType = new RatingLabelType();
            this.saveLabelType((AbstractStorageLabelType<?>)ratingLabelType);
        }
        List ratingLabelList = this.getAllLabelsForType((AbstractStorageLabelType)ratingLabelType);
        if (ratingLabelList.isEmpty()) {
            this.saveLabel((AbstractStorageLabel<?>)new StringStorageLabel("Very Bad", (AbstractStorageLabelType)ratingLabelType));
            this.saveLabel((AbstractStorageLabel<?>)new StringStorageLabel("Bad", (AbstractStorageLabelType)ratingLabelType));
            this.saveLabel((AbstractStorageLabel<?>)new StringStorageLabel("Medium", (AbstractStorageLabelType)ratingLabelType));
            this.saveLabel((AbstractStorageLabel<?>)new StringStorageLabel("Good", (AbstractStorageLabelType)ratingLabelType));
            this.saveLabel((AbstractStorageLabel<?>)new StringStorageLabel("Very Good", (AbstractStorageLabelType)ratingLabelType));
        }
        if (CollectionUtils.isNotEmpty(statusLabelTypeList = this.getLabelTypes(StatusLabelType.class))) {
            statusLabelType = statusLabelTypeList.get(0);
        } else {
            statusLabelType = new StatusLabelType();
            this.saveLabelType((AbstractStorageLabelType<?>)statusLabelType);
        }
        List statusLabelList = this.getAllLabelsForType((AbstractStorageLabelType)statusLabelType);
        if (statusLabelList.isEmpty()) {
            this.saveLabel((AbstractStorageLabel<?>)new StringStorageLabel("Awaiting Review", (AbstractStorageLabelType)statusLabelType));
            this.saveLabel((AbstractStorageLabel<?>)new StringStorageLabel("In-Progress", (AbstractStorageLabelType)statusLabelType));
            this.saveLabel((AbstractStorageLabel<?>)new StringStorageLabel("Closed", (AbstractStorageLabelType)statusLabelType));
        }
    }

    private <E> List<E> loadAll(Class<E> clazz) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(clazz);
        criteria.from(clazz);
        return this.entityManager.createQuery(criteria).getResultList();
    }
}

