/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.dao.impl;

import info.novatec.inspectit.cmr.dao.MethodIdentDao;
import info.novatec.inspectit.cmr.dao.impl.AbstractJpaDao;
import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.util.PlatformIdentCache;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class MethodIdentDaoImpl
extends AbstractJpaDao<MethodIdent>
implements MethodIdentDao {
    @Autowired
    private PlatformIdentCache platformIdentCache;

    public MethodIdentDaoImpl() {
        super(MethodIdent.class);
    }

    @Override
    public void saveOrUpdate(MethodIdent methodIdent) {
        if (null == methodIdent.getId()) {
            super.create(methodIdent);
        } else {
            super.update(methodIdent);
        }
        this.platformIdentCache.markDirty(methodIdent.getPlatformIdent());
    }

    @Override
    public List<MethodIdent> findAll() {
        return this.getEntityManager().createNamedQuery("MethodIdent.findAll", MethodIdent.class).getResultList();
    }

    @Override
    public List<MethodIdent> findForPlatformIdAndExample(long platformId, MethodIdent methodIdentExample) {
        TypedQuery query = this.getEntityManager().createNamedQuery("MethodIdent.findByPlatformAndExample", MethodIdent.class);
        query.setParameter("platformIdent", (Object)platformId);
        query.setParameter("className", (Object)methodIdentExample.getClassName());
        query.setParameter("methodName", (Object)methodIdentExample.getMethodName());
        query.setParameter("returnType", (Object)methodIdentExample.getReturnType());
        if (null != methodIdentExample.getPackageName()) {
            query.setParameter("packageName", (Object)methodIdentExample.getPackageName());
        } else {
            query.setParameter("packageName", (Object)"null");
        }
        List results = query.getResultList();
        Iterator it = results.iterator();
        while (it.hasNext()) {
            MethodIdent methodIdent = (MethodIdent)it.next();
            if (CollectionUtils.isEqualCollection((Collection)methodIdent.getParameters(), (Collection)methodIdentExample.getParameters())) continue;
            it.remove();
        }
        return results;
    }
}

