/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.cache;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.Sizeable;
import info.novatec.inspectit.util.UnderlyingSystemInfo;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractObjectSizes
implements IObjectSizes {
    public static final long BOOLEAN_SIZE = 1L;
    public static final long CHAR_SIZE = 2L;
    public static final long SHORT_SIZE = 2L;
    public static final long INT_SIZE = 4L;
    public static final long FLOAT_SIZE = 4L;
    public static final long LONG_SIZE = 8L;
    public static final long DOUBLE_SIZE = 8L;
    private static final int ARRAY_LIST_INITIAL_CAPACITY = 10;
    private static final int MAP_INITIAL_CAPACITY = 16;
    private static final boolean ALLIGN_CLASS_CALCULATION = UnderlyingSystemInfo.IS_64BIT && !UnderlyingSystemInfo.IS_COMPRESSED_OOPS;
    private float objectSecurityExpansionRate = 0.2f;

    public abstract long getReferenceSize();

    public long getSizeOf(Sizeable sizeable) {
        if (null == sizeable) {
            return 0L;
        }
        long size = sizeable.getObjectSize((IObjectSizes)this, ALLIGN_CLASS_CALCULATION);
        return ALLIGN_CLASS_CALCULATION ? size : this.alignTo8Bytes(size);
    }

    public long getSizeOf(String str) {
        if (null == str) {
            return 0L;
        }
        long size = this.getSizeOfObjectHeader();
        size += this.getPrimitiveTypesSize(1, 0, 2, 0, 0, 0);
        return this.alignTo8Bytes(size += this.getSizeOfPrimitiveArray(str.length(), 2L));
    }

    public long getSizeOf(String ... strings) {
        HashSet<Integer> identityHashCodeSet = new HashSet<Integer>();
        long size = 0L;
        for (String str : strings) {
            if (null == str || !identityHashCodeSet.add(System.identityHashCode(str))) continue;
            size += this.getSizeOf(str);
        }
        return size;
    }

    public long getSizeOf(Timestamp timestamp) {
        if (null == timestamp) {
            return 0L;
        }
        long size = this.getSizeOfObjectHeader();
        size += this.getPrimitiveTypesSize(0, 0, 1, 0, 0, 0);
        return this.alignTo8Bytes(size += this.getPrimitiveTypesSize(1, 0, 0, 0, 1, 0));
    }

    public long getSizeOf(List<?> arrayList) {
        return this.getSizeOf(arrayList, 10);
    }

    public long getSizeOf(List<?> arrayList, int initialCapacity) {
        if (null == arrayList) {
            return 0L;
        }
        int capacity = this.getArrayCapacity(arrayList.size(), initialCapacity);
        long size = this.alignTo8Bytes(this.getSizeOfObjectHeader() + this.getPrimitiveTypesSize(1, 0, 2, 0, 0, 0));
        return this.alignTo8Bytes(size += this.getSizeOfArray(capacity));
    }

    protected int getArrayCapacity(int size, int initialCapacity) {
        if (0 == size) {
            return 0;
        }
        while (initialCapacity < size) {
            if (initialCapacity == 0 || initialCapacity == 1) {
                ++initialCapacity;
                continue;
            }
            initialCapacity += initialCapacity >> 1;
        }
        return initialCapacity;
    }

    public long getSizeOfCustomWeakReference() {
        long size = this.getSizeOfObjectHeader();
        return this.alignTo8Bytes(size += this.getPrimitiveTypesSize(4, 0, 0, 0, 1, 0));
    }

    public long getSizeOfHashSet(int hashSetSize) {
        return this.getSizeOfHashSet(hashSetSize, 16);
    }

    public long getSizeOfHashSet(int hashSetSize, int initialCapacity) {
        long size = this.getSizeOfObjectHeader();
        size += this.getPrimitiveTypesSize(1, 0, 0, 0, 0, 0);
        size += this.getSizeOfHashMap(hashSetSize, initialCapacity);
        if (hashSetSize > 0) {
            size += this.getSizeOfObjectObject();
        }
        return this.alignTo8Bytes(size);
    }

    public long getSizeOfHashMap(int hashMapSize) {
        return this.getSizeOfHashMap(hashMapSize, 16);
    }

    public long getSizeOfHashMap(int hashMapSize, int initialCapacity) {
        long size = this.getSizeOfObjectHeader();
        size += this.getPrimitiveTypesSize(4, 0, 4, 1, 0, 0);
        int mapCapacity = this.getHashMapCapacityFromSize(hashMapSize, initialCapacity);
        size += this.getSizeOfArray(mapCapacity);
        size += (long)hashMapSize * this.getSizeOfHashMapEntry();
        return this.alignTo8Bytes(size += this.getSizeOfHashMapKeyEntrySet());
    }

    public long getSizeOfHashMapKeyEntrySet() {
        long size = this.getSizeOfObjectHeader() + this.getPrimitiveTypesSize(1, 0, 0, 0, 0, 0);
        return this.alignTo8Bytes(size);
    }

    public long getSizeOfConcurrentHashMap(int mapSize, int concurrencyLevel) {
        long size = this.getSizeOfObjectHeader();
        size += this.getPrimitiveTypesSize(6, 0, 3, 0, 0, 0);
        size += this.getSizeOfArray(concurrencyLevel);
        int segmentCapacity = this.getSegmentCapacityFromSize(mapSize / concurrencyLevel, 16 / concurrencyLevel);
        int segments = this.getNumberOfConcurrentSegments(mapSize, concurrencyLevel);
        size += (long)segments * this.getSizeOfConcurrentSeqment(segmentCapacity);
        return this.alignTo8Bytes(size += (long)mapSize * this.getSizeOfHashMapEntry());
    }

    public long getSizeOfNonBlockingHashMapLong(int mapSize) {
        long size = this.getSizeOfObjectHeader();
        size += this.getPrimitiveTypesSize(5, 1, 0, 0, 1, 0);
        size = this.alignTo8Bytes(size);
        size += this.getSizeOfObjectObject();
        size += this.getSizeOfHighScaleLibCounter();
        return size += this.getSizeOfHighScaleLibCHM(mapSize);
    }

    private long getSizeOfHighScaleLibCHM(int mapSize) {
        long size = this.getSizeOfObjectHeader();
        size += this.getPrimitiveTypesSize(6, 0, 0, 0, 3, 0);
        size = this.alignTo8Bytes(size);
        size += this.getSizeOfHighScaleLibCounter() << 1;
        int tablesSize = mapSize <= 16 ? 16 : 1 << 32 - Integer.numberOfLeadingZeros(mapSize - 1);
        size += this.getSizeOfPrimitiveArray(tablesSize, 8L);
        return size += this.getSizeOfPrimitiveArray(tablesSize, this.getReferenceSize());
    }

    private long getSizeOfHighScaleLibCounter() {
        long size = this.getSizeOfObjectHeader();
        size += this.getPrimitiveTypesSize(1, 0, 0, 0, 0, 0);
        size = this.alignTo8Bytes(size);
        return size += this.getSizeOfHighScaleLibCAT();
    }

    private long getSizeOfHighScaleLibCAT() {
        long size = this.getSizeOfObjectHeader();
        size += this.getPrimitiveTypesSize(2, 0, 0, 0, 4, 0);
        size = this.alignTo8Bytes(size);
        return size += this.getSizeOfPrimitiveArray(4, 8L);
    }

    protected int getNumberOfConcurrentSegments(int mapSize, int concurrencyLevel) {
        return mapSize == 0 ? 1 : concurrencyLevel;
    }

    public long alignTo8Bytes(long size) {
        long d = size % 8L;
        if (d == 0L) {
            return size;
        }
        return size + 8L - d;
    }

    public long getSizeOfObjectObject() {
        return this.alignTo8Bytes(this.getSizeOfObjectHeader());
    }

    public long getSizeOfLongObject() {
        long size = this.getSizeOfObjectHeader() + 8L;
        return this.alignTo8Bytes(size);
    }

    public long getSizeOfIntegerObject() {
        long size = this.getSizeOfObjectHeader() + 4L;
        return this.alignTo8Bytes(size);
    }

    public long getSizeOfShortObject() {
        long size = this.getSizeOfObjectHeader() + 2L;
        return this.alignTo8Bytes(size);
    }

    public long getSizeOfCharacterObject() {
        long size = this.getSizeOfObjectHeader() + 2L;
        return this.alignTo8Bytes(size);
    }

    public long getSizeOfBooleanObject() {
        long size = this.getSizeOfObjectHeader() + 1L;
        return this.alignTo8Bytes(size);
    }

    public long getPrimitiveTypesSize(int referenceCount, int booleanCount, int intCount, int floatCount, int longCount, int doubleCount) {
        long booleanSize = 0L;
        if (booleanCount > 0) {
            booleanSize = (long)booleanCount * 1L + 4L - (long)booleanCount * 1L % 4L;
        }
        return booleanSize + (long)referenceCount * this.getReferenceSize() + (long)intCount * 4L + (long)floatCount * 4L + (long)longCount * 8L + (long)doubleCount * 8L;
    }

    public float getObjectSecurityExpansionRate() {
        return this.objectSecurityExpansionRate;
    }

    public void setObjectSecurityExpansionRate(float objectSecurityExpansionRate) {
        this.objectSecurityExpansionRate = objectSecurityExpansionRate;
    }

    public long getSizeOfArray(int arraySize) {
        long size = this.getSizeOfObjectHeader();
        return this.alignTo8Bytes(size += this.getPrimitiveTypesSize(arraySize, 0, 1, 0, 0, 0));
    }

    public long getSizeOfPrimitiveArray(int arraySize, long primitiveSize) {
        long size = this.getSizeOfObjectHeader() + 4L;
        if (ALLIGN_CLASS_CALCULATION) {
            size = this.alignTo8Bytes(size);
        }
        return this.alignTo8Bytes(size += (long)arraySize * primitiveSize);
    }

    protected long getSizeOfConcurrentSeqment(int seqmentCapacity) {
        long size = this.getSizeOfObjectHeader();
        size += this.getPrimitiveTypesSize(2, 0, 3, 1, 0, 0);
        size += this.alignTo8Bytes(this.getSizeOfObjectHeader() + this.getPrimitiveTypesSize(3, 0, 1, 0, 0, 0));
        return this.alignTo8Bytes(size += this.getSizeOfArray(seqmentCapacity));
    }

    private long getSizeOfHashMapEntry() {
        long size = this.getSizeOfObjectHeader();
        return this.alignTo8Bytes(size += this.getPrimitiveTypesSize(3, 0, 1, 0, 0, 0));
    }

    public int getHashMapCapacityFromSize(int hashMapSize, int initialCapacity) {
        if (hashMapSize == 0) {
            return 0;
        }
        int capacity = 1;
        if (initialCapacity > 0) {
            capacity = initialCapacity;
        }
        float loadFactor = 0.75f;
        int threshold = (int)((float)capacity * loadFactor);
        while (threshold < hashMapSize) {
            threshold = (int)((float)(capacity *= 2) * loadFactor);
        }
        return capacity;
    }

    protected int getSegmentCapacityFromSize(int seqmentSize, int initialCapacity) {
        int capacity = initialCapacity;
        float loadFactor = 0.75f;
        int threshold = (int)((float)capacity * loadFactor);
        while (threshold + 1 <= seqmentSize) {
            threshold = (int)((float)(capacity *= 2) * loadFactor);
        }
        return capacity;
    }
}

