/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.processor.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.ExceptionEvent;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.storage.processor.AbstractDataProcessor;
import info.novatec.inspectit.storage.processor.AbstractExtractorDataProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;

public class InvocationExtractorDataProcessor
extends AbstractExtractorDataProcessor {
    private static final long serialVersionUID = -3793308278679460679L;

    public InvocationExtractorDataProcessor() {
        this(Collections.emptyList());
    }

    public InvocationExtractorDataProcessor(List<AbstractDataProcessor> chainedDataProcessors) {
        super(chainedDataProcessors);
    }

    @Override
    protected Collection<Future<Void>> processData(DefaultData defaultData) {
        if (defaultData instanceof InvocationSequenceData) {
            InvocationSequenceData invocation = (InvocationSequenceData)defaultData;
            this.extractDataFromInvocation(invocation);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean canBeProcessed(DefaultData defaultData) {
        return defaultData instanceof InvocationSequenceData;
    }

    private void extractDataFromInvocation(InvocationSequenceData invocation) {
        if (null != invocation.getTimerData()) {
            this.passToChainedProcessors((DefaultData)invocation.getTimerData());
        }
        if (null != invocation.getSqlStatementData()) {
            this.passToChainedProcessors((DefaultData)invocation.getSqlStatementData());
        }
        if (null != invocation.getExceptionSensorDataObjects()) {
            for (ExceptionSensorData exceptionSensorData : invocation.getExceptionSensorDataObjects()) {
                if (exceptionSensorData.getExceptionEvent() != ExceptionEvent.CREATED) continue;
                this.passToChainedProcessors((DefaultData)exceptionSensorData);
            }
        }
        for (InvocationSequenceData child : invocation.getNestedSequences()) {
            this.extractDataFromInvocation(child);
        }
    }
}

