/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.nio.write;

import info.novatec.inspectit.storage.nio.WriteReadAttachment;
import info.novatec.inspectit.storage.nio.WriteReadCompletionRunnable;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritingCompletionHandler
implements CompletionHandler<Integer, WriteReadAttachment> {
    private static final Logger LOG = LoggerFactory.getLogger(WritingCompletionHandler.class);

    @Override
    public void completed(Integer result, WriteReadAttachment attachment) {
        long bytesToWriteMore = attachment.getSize() - result.longValue();
        if (bytesToWriteMore > 0L) {
            long writingSize = bytesToWriteMore;
            long writingPosition = attachment.getPosition() + result.longValue();
            attachment.setPosition(writingPosition);
            attachment.setSize(writingSize);
            attachment.getFileChannel().write(attachment.getByteBuffer(), writingPosition, attachment, this);
        } else {
            WriteReadCompletionRunnable completionRunnable = attachment.getCompletionRunnable();
            if (null != completionRunnable) {
                completionRunnable.markSuccess();
                if (completionRunnable.isFinished()) {
                    completionRunnable.run();
                }
            }
        }
    }

    @Override
    public void failed(Throwable exc, WriteReadAttachment attachment) {
        LOG.error("Write to the disk failed.", exc);
        WriteReadCompletionRunnable completionRunnable = attachment.getCompletionRunnable();
        if (null != completionRunnable) {
            completionRunnable.markFailed();
            if (completionRunnable.isFinished()) {
                completionRunnable.run();
            }
        }
    }
}

