/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.nio.write;

import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.storage.nio.AbstractChannelManager;
import info.novatec.inspectit.storage.nio.CustomAsyncChannel;
import info.novatec.inspectit.storage.nio.WriteReadAttachment;
import info.novatec.inspectit.storage.nio.WriteReadCompletionRunnable;
import info.novatec.inspectit.storage.nio.stream.ExtendedByteBufferOutputStream;
import info.novatec.inspectit.storage.nio.write.WritingCompletionHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WritingChannelManager
extends AbstractChannelManager {
    @Log
    Logger log;
    @Value(value="${storage.maxWriteChannelsOpened}")
    private int maxOpenedChannels = 128;

    public long write(ByteBuffer byteBuffer, Path channelPath, WriteReadCompletionRunnable completionRunnable) throws IOException {
        CustomAsyncChannel channel = super.getChannel(channelPath);
        long writingSize = byteBuffer.limit() - byteBuffer.position();
        long writingPosition = channel.reserveWritingPosition(writingSize);
        WriteReadAttachment attachment = new WriteReadAttachment();
        attachment.setByteBuffer(byteBuffer);
        attachment.setSize(writingSize);
        attachment.setPosition(writingPosition);
        completionRunnable.setAttemptedWriteReadSize(writingSize);
        completionRunnable.setAttemptedWriteReadPosition(writingPosition);
        attachment.setCompletionRunnable(completionRunnable);
        attachment.setFileChannel(channel.getFileChannel());
        boolean wrote = false;
        while (!wrote) {
            wrote = channel.write(byteBuffer, writingPosition, attachment, new WritingCompletionHandler());
            if (wrote) continue;
            if (this.log.isDebugEnabled()) {
                this.log.info("Failed to submit writing IO task, channel is closed. Trying to reopen the channel..");
            }
            this.openAsyncChannel(channel);
        }
        return writingPosition;
    }

    public long write(ExtendedByteBufferOutputStream extendedByteBufferOutputStream, Path channelPath, WriteReadCompletionRunnable completionRunnable) throws IOException {
        CustomAsyncChannel channel = super.getChannel(channelPath);
        List byteBuffers = extendedByteBufferOutputStream.getAllByteBuffers();
        long totalWritingSize = extendedByteBufferOutputStream.getTotalWriteSize();
        long writingPosition = channel.reserveWritingPosition(totalWritingSize);
        completionRunnable.setAttemptedWriteReadSize(totalWritingSize);
        completionRunnable.setAttemptedWriteReadPosition(writingPosition);
        long returnWritingPosition = writingPosition;
        for (ByteBuffer byteBuffer : byteBuffers) {
            long writingSize = byteBuffer.limit() - byteBuffer.position();
            WriteReadAttachment attachment = new WriteReadAttachment();
            attachment.setByteBuffer(byteBuffer);
            attachment.setSize(writingSize);
            attachment.setPosition(writingPosition);
            attachment.setCompletionRunnable(completionRunnable);
            attachment.setFileChannel(channel.getFileChannel());
            boolean wrote = false;
            while (!wrote) {
                wrote = channel.write(byteBuffer, writingPosition, attachment, new WritingCompletionHandler());
                if (wrote) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.info("Failed to submit writing IO task, channel is closed. Trying to reopen the channel..");
                }
                this.openAsyncChannel(channel);
            }
            writingPosition += writingSize;
        }
        return returnWritingPosition;
    }

    @Override
    protected int getMaxOpenedChannels() {
        return this.maxOpenedChannels;
    }
}

