/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.nio;

import info.novatec.inspectit.storage.nio.CustomAsyncChannel;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractChannelManager {
    private Map<Path, CustomAsyncChannel> writingChannelsMap = new ConcurrentHashMap<Path, CustomAsyncChannel>(64, 0.75f, 1);
    private ConcurrentLinkedQueue<CustomAsyncChannel> openedChannelsQueue = new ConcurrentLinkedQueue();
    @Autowired
    @Resource(name="IOExecutorService")
    private ExecutorService executorService;
    private AtomicInteger openedChannelsCount = new AtomicInteger(0);

    protected abstract int getMaxOpenedChannels();

    protected CustomAsyncChannel getChannel(Path channelPath) throws IOException {
        CustomAsyncChannel channel = this.writingChannelsMap.get(channelPath);
        if (channel == null) {
            channel = this.createNewChannel(channelPath);
        }
        return channel;
    }

    private synchronized CustomAsyncChannel createNewChannel(Path channelPath) throws IOException {
        CustomAsyncChannel channel = this.writingChannelsMap.get(channelPath);
        if (channel == null) {
            channel = new CustomAsyncChannel(channelPath);
            this.openAsyncChannel(channel);
            this.writingChannelsMap.put(channelPath, channel);
        }
        return channel;
    }

    protected void openAsyncChannel(CustomAsyncChannel customAsyncChannel) throws IOException {
        boolean channelOpened = customAsyncChannel.openChannel(this.executorService);
        if (channelOpened) {
            this.openedChannelsQueue.add(customAsyncChannel);
            int channelsOpened = this.openedChannelsCount.incrementAndGet();
            while (channelsOpened > this.getMaxOpenedChannels()) {
                this.closeOldestAsyncChannel();
                channelsOpened = this.openedChannelsCount.get();
            }
        }
    }

    protected void closeOldestAsyncChannel() throws IOException {
        CustomAsyncChannel channelToClose = this.openedChannelsQueue.poll();
        if (null != channelToClose && channelToClose.closeChannel()) {
            this.openedChannelsCount.decrementAndGet();
        }
    }

    protected void closeAsyncChannel(CustomAsyncChannel channelToClose) throws IOException {
        this.openedChannelsQueue.remove(channelToClose);
        if (channelToClose.closeChannel()) {
            this.openedChannelsCount.decrementAndGet();
        }
    }

    public void finalizeAllChannels() throws IOException {
        for (CustomAsyncChannel channel : this.writingChannelsMap.values()) {
            if (channel.isOpened()) {
                this.closeAsyncChannel(channel);
            }
            this.writingChannelsMap.values().remove(channel);
        }
    }

    public void finalizeChannel(Path channelPath) throws IOException {
        CustomAsyncChannel channel = this.writingChannelsMap.remove(channelPath);
        if (channel != null && channel.isOpened()) {
            this.closeAsyncChannel(channel);
        }
    }

    public String getExecutorServiceStatus() {
        return this.executorService.toString();
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("currentOpenedChannels", this.openedChannelsCount.get());
        toStringBuilder.append("executorService", (Object)this.executorService);
        toStringBuilder.append("writingChannelsMap", this.writingChannelsMap);
        return toStringBuilder.toString();
    }
}

