/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.label.management.impl;

import info.novatec.inspectit.cmr.service.IStorageService;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.management.AbstractLabelManagementAction;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RemoveLabelManagementAction
extends AbstractLabelManagementAction {
    private static final long serialVersionUID = -5553041046576560998L;
    private boolean removeFromStorageAlso;

    public RemoveLabelManagementAction() {
        this(Collections.emptyList(), false);
    }

    public RemoveLabelManagementAction(AbstractStorageLabelType<?> labelType, boolean removeFromStorageAlso) {
        super(labelType);
        this.removeFromStorageAlso = removeFromStorageAlso;
    }

    public RemoveLabelManagementAction(Collection<AbstractStorageLabel<?>> labelList, boolean removeFromStorageAlso) {
        super(labelList);
        this.removeFromStorageAlso = removeFromStorageAlso;
    }

    @Override
    public void execute(IStorageService storageService) throws BusinessException {
        if (this.isLabelTypeBasedAction()) {
            List<AbstractStorageLabel<?>> returnList;
            List<AbstractStorageLabel<?>> labels = returnList = storageService.getLabelSuggestions(this.getLabelType());
            storageService.removeLabelsFromCmr(labels, this.isRemoveFromStorageAlso());
            storageService.removeLabelType(this.getLabelType());
        } else if (this.isLabelBasedAction()) {
            Collection<AbstractStorageLabel<?>> labels = this.getLabelList();
            storageService.removeLabelsFromCmr(labels, this.isRemoveFromStorageAlso());
        }
    }

    public boolean isRemoveFromStorageAlso() {
        return this.removeFromStorageAlso;
    }

    public void setRemoveFromStorageAlso(boolean removeFromStorageAlso) {
        this.removeFromStorageAlso = removeFromStorageAlso;
    }
}

