/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.label.management;

import info.novatec.inspectit.cmr.service.IStorageService;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractLabelManagementAction
implements Serializable {
    private static final long serialVersionUID = -3640398456749258696L;
    private final AbstractStorageLabelType<?> labelType;
    private final Collection<AbstractStorageLabel<?>> labelList;

    public AbstractLabelManagementAction(AbstractStorageLabelType<?> labelType) {
        this.labelType = labelType;
        this.labelList = Collections.emptyList();
    }

    public AbstractLabelManagementAction(Collection<AbstractStorageLabel<?>> labelList) {
        this.labelType = null;
        this.labelList = labelList;
    }

    public abstract void execute(IStorageService var1) throws BusinessException;

    public boolean isLabelTypeBasedAction() {
        return null != this.labelType;
    }

    public boolean isLabelBasedAction() {
        return null != this.labelList && !this.labelList.isEmpty();
    }

    public AbstractStorageLabelType<?> getLabelType() {
        return this.labelType;
    }

    public Collection<AbstractStorageLabel<?>> getLabelList() {
        return this.labelList;
    }
}

