/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.storage.impl;

import info.novatec.inspectit.indexing.storage.AbstractStorageDescriptor;
import info.novatec.inspectit.indexing.storage.IStorageDescriptor;
import info.novatec.inspectit.indexing.storage.impl.SimpleStorageDescriptor;
import org.apache.commons.lang.builder.ToStringBuilder;

public class StorageDescriptor
extends AbstractStorageDescriptor {
    private int channelId;
    private SimpleStorageDescriptor simpleStorageDescriptor;

    public StorageDescriptor() {
        this.simpleStorageDescriptor = new SimpleStorageDescriptor();
    }

    public StorageDescriptor(int channelId) {
        this();
        this.channelId = channelId;
    }

    public StorageDescriptor(int channelId, SimpleStorageDescriptor simpleStorageDescriptor) {
        this.channelId = channelId;
        this.simpleStorageDescriptor = simpleStorageDescriptor;
    }

    public StorageDescriptor(int channelId, long position, long size) {
        this.channelId = channelId;
        this.simpleStorageDescriptor = new SimpleStorageDescriptor(position, (int)size);
    }

    public boolean join(IStorageDescriptor other) {
        if (this.getChannelId() != other.getChannelId()) {
            return false;
        }
        return this.join(other.getPosition(), other.getSize());
    }

    public boolean join(long otherPosition, long otherSize) {
        return this.simpleStorageDescriptor.join(otherPosition, otherSize);
    }

    @Override
    public int getChannelId() {
        return this.channelId;
    }

    @Override
    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public SimpleStorageDescriptor getSimpleStorageDescriptor() {
        return this.simpleStorageDescriptor;
    }

    public void setSimpleStorageDescriptor(SimpleStorageDescriptor simpleStorageDescriptor) {
        this.simpleStorageDescriptor = simpleStorageDescriptor;
    }

    @Override
    public long getPosition() {
        return this.simpleStorageDescriptor.getPosition();
    }

    @Override
    public long getSize() {
        return this.simpleStorageDescriptor.getSize();
    }

    @Override
    public void setPositionAndSize(long position, long size) {
        this.simpleStorageDescriptor.setPosition(position);
        this.simpleStorageDescriptor.setSize((int)size);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.channelId;
        result = 31 * result + (this.simpleStorageDescriptor == null ? 0 : this.simpleStorageDescriptor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageDescriptor other = (StorageDescriptor)obj;
        if (this.channelId != other.channelId) {
            return false;
        }
        return !(this.simpleStorageDescriptor == null ? other.simpleStorageDescriptor != null : !this.simpleStorageDescriptor.equals(other.simpleStorageDescriptor));
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("channelId", this.channelId);
        toStringBuilder.append("position", this.simpleStorageDescriptor.getPosition());
        toStringBuilder.append("size", this.simpleStorageDescriptor.getSize());
        return toStringBuilder.toString();
    }
}

