/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.storage.impl;

import org.apache.commons.lang.builder.ToStringBuilder;

public class SimpleStorageDescriptor {
    private long position;
    private int size;

    public SimpleStorageDescriptor() {
    }

    public SimpleStorageDescriptor(long position, int size) {
        this.position = position;
        this.size = size;
    }

    public boolean join(SimpleStorageDescriptor other) {
        return this.join(other.getPosition(), other.getSize());
    }

    public boolean join(long otherPosition, long otherSize) {
        if (this.position + (long)this.size == otherPosition) {
            this.size = (int)((long)this.size + otherSize);
            return true;
        }
        if (otherPosition + otherSize == this.position) {
            this.position = otherPosition;
            this.size = (int)((long)this.size + otherSize);
            return true;
        }
        return false;
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.position ^ this.position >>> 32);
        result = 31 * result + this.size;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleStorageDescriptor other = (SimpleStorageDescriptor)obj;
        if (this.position != other.position) {
            return false;
        }
        return this.size == other.size;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("position", this.position);
        toStringBuilder.append("size", this.size);
        return toStringBuilder.toString();
    }
}

