/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.restriction;

import info.novatec.inspectit.indexing.restriction.IIndexQueryRestriction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractIndexQueryRestriction
implements IIndexQueryRestriction {
    private final List<String> methodNames;

    public AbstractIndexQueryRestriction(String fieldName) {
        if (null == fieldName) {
            throw new IllegalArgumentException();
        }
        String[] split = StringUtils.splitPreserveAllTokens((String)fieldName, (char)'.');
        this.methodNames = new ArrayList<String>(split.length);
        int size = split.length;
        for (int i = 0; i < size; ++i) {
            this.methodNames.add(this.getMethodName(split[i]));
        }
    }

    public List<String> getQualifiedMethodNames() {
        return Collections.unmodifiableList(this.methodNames);
    }

    private String getMethodName(String fieldName) {
        return "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.methodNames == null ? 0 : this.methodNames.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractIndexQueryRestriction other = (AbstractIndexQueryRestriction)obj;
        return !(this.methodNames == null ? other.methodNames != null : !this.methodNames.equals(other.methodNames));
    }
}

