/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.query.factory.impl;

import info.novatec.inspectit.communication.data.AggregatedSqlStatementData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.query.factory.AbstractQueryFactory;
import info.novatec.inspectit.indexing.restriction.impl.IndexQueryRestrictionFactory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class SqlStatementDataQueryFactory<E extends IIndexQuery>
extends AbstractQueryFactory<E> {
    public E getAggregatedSqlStatementsQuery(SqlStatementData sqlStatementData, Date fromDate, Date toDate) {
        Object query = this.getIndexQueryProvider().getIndexQuery();
        query.setPlatformIdent(sqlStatementData.getPlatformIdent());
        ArrayList<Class> searchedClasses = new ArrayList<Class>();
        searchedClasses.add(SqlStatementData.class);
        searchedClasses.add(AggregatedSqlStatementData.class);
        query.setObjectClasses(searchedClasses);
        if (null != sqlStatementData.getSql()) {
            query.addIndexingRestriction(IndexQueryRestrictionFactory.equal("sql", sqlStatementData.getSql()));
        }
        if (null != sqlStatementData.getDatabaseProductName()) {
            query.addIndexingRestriction(IndexQueryRestrictionFactory.equal("databaseProductName", sqlStatementData.getDatabaseProductName()));
        }
        if (null != sqlStatementData.getDatabaseProductVersion()) {
            query.addIndexingRestriction(IndexQueryRestrictionFactory.equal("databaseProductVersion", sqlStatementData.getDatabaseProductVersion()));
        }
        if (null != sqlStatementData.getDatabaseUrl()) {
            query.addIndexingRestriction(IndexQueryRestrictionFactory.equal("databaseUrl", sqlStatementData.getDatabaseUrl()));
        }
        if (null != fromDate) {
            query.setFromDate(new Timestamp(fromDate.getTime()));
        }
        if (null != toDate) {
            query.setToDate(new Timestamp(toDate.getTime()));
        }
        return query;
    }
}

