/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.indexer.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.indexer.IBranchIndexer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public class TimestampIndexer<E extends DefaultData>
implements IBranchIndexer<E> {
    private static final Object[] EMPTY_KEYS = new Object[0];
    private static final long INDEXING_PERIOD = 900000L;
    private ConcurrentHashMap<Long, Boolean> createdKeysMap = new ConcurrentHashMap(8, 0.75f, 1);
    private long minCreatedKey = Long.MAX_VALUE;
    private long maxCreatedKey = 0L;

    @Override
    public Object getKey(E element) {
        if (null == element.getTimeStamp()) {
            return null;
        }
        long key = this.getKey(element.getTimeStamp());
        this.createdKeysMap.put(key, Boolean.TRUE);
        if (key < this.minCreatedKey) {
            this.minCreatedKey = key;
        }
        if (key > this.maxCreatedKey) {
            this.maxCreatedKey = key;
        }
        return key;
    }

    @Override
    public Object[] getKeys(IIndexQuery query) {
        if (!query.isIntervalSet()) {
            return EMPTY_KEYS;
        }
        long startKey = 0L;
        if (null != query.getFromDate()) {
            startKey = this.getKey(query.getFromDate());
        }
        if (startKey < this.minCreatedKey) {
            startKey = this.minCreatedKey;
        }
        long endKey = Long.MAX_VALUE;
        if (null != query.getToDate()) {
            endKey = this.getKey(query.getToDate());
        }
        if (endKey > this.maxCreatedKey) {
            endKey = this.maxCreatedKey;
        }
        int size = (int)((endKey - startKey) / 900000L + 1L);
        ArrayList<Long> keysList = new ArrayList<Long>();
        for (int i = 0; i < size; ++i) {
            long key = startKey + (long)i * 900000L;
            if (!this.createdKeysMap.containsKey(key)) continue;
            keysList.add(key);
        }
        return keysList.toArray(new Object[keysList.size()]);
    }

    private long getKey(Timestamp timestamp) {
        return timestamp.getTime() - timestamp.getTime() % 900000L;
    }

    @Override
    public boolean sharedInstance() {
        return false;
    }

    @Override
    public IBranchIndexer<E> getNewInstance() {
        return new TimestampIndexer<E>();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.createdKeysMap == null ? 0 : this.createdKeysMap.hashCode());
        result = 31 * result + (int)(this.maxCreatedKey ^ this.maxCreatedKey >>> 32);
        result = 31 * result + (int)(this.minCreatedKey ^ this.minCreatedKey >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimestampIndexer other = (TimestampIndexer)obj;
        if (this.createdKeysMap == null ? other.createdKeysMap != null : !this.createdKeysMap.equals(other.createdKeysMap)) {
            return false;
        }
        if (this.maxCreatedKey != other.maxCreatedKey) {
            return false;
        }
        return this.minCreatedKey == other.minCreatedKey;
    }
}

