/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.restriction.IIndexQueryRestriction;
import info.novatec.inspectit.indexing.restriction.IIndexQueryRestrictionProcessor;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Lazy
public class IndexQuery
implements IIndexQuery {
    @Autowired
    IIndexQueryRestrictionProcessor restrictionProcessor;
    private long minId;
    private long platformIdent;
    private long sensorTypeIdent;
    private long methodIdent;
    private List<Class<?>> objectClasses;
    private Timestamp fromDate;
    private Timestamp toDate;
    private List<IIndexQueryRestriction> indexingRestrictionList = new ArrayList<IIndexQueryRestriction>();

    public long getMinId() {
        return this.minId;
    }

    public void setMinId(long minId) {
        this.minId = minId;
    }

    public long getPlatformIdent() {
        return this.platformIdent;
    }

    public void setPlatformIdent(long platformIdent) {
        this.platformIdent = platformIdent;
    }

    public long getSensorTypeIdent() {
        return this.sensorTypeIdent;
    }

    public void setSensorTypeIdent(long sensorTypeIdent) {
        this.sensorTypeIdent = sensorTypeIdent;
    }

    public long getMethodIdent() {
        return this.methodIdent;
    }

    public void setMethodIdent(long methodIdent) {
        this.methodIdent = methodIdent;
    }

    public List<Class<?>> getObjectClasses() {
        return this.objectClasses;
    }

    public void setObjectClasses(List objectClasses) {
        this.objectClasses = objectClasses;
    }

    public Timestamp getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Timestamp fromDate) {
        this.fromDate = fromDate;
    }

    public Timestamp getToDate() {
        return this.toDate;
    }

    public void setToDate(Timestamp toDate) {
        this.toDate = toDate;
    }

    public void addIndexingRestriction(IIndexQueryRestriction indexingRestriction) {
        this.indexingRestrictionList.add(indexingRestriction);
    }

    protected List<IIndexQueryRestriction> getIndexingRestrictionList() {
        return this.indexingRestrictionList;
    }

    public boolean isIntervalSet() {
        if (null != this.fromDate) {
            if (null == this.toDate) {
                return true;
            }
            return this.fromDate.before(this.toDate);
        }
        return null != this.toDate;
    }

    public boolean isInInterval(Timestamp timestamp) {
        if (this.isIntervalSet()) {
            if (null == timestamp) {
                return false;
            }
            if (this.fromDate != null && this.fromDate.compareTo(timestamp) > 0) {
                return false;
            }
            return this.toDate == null || this.toDate.compareTo(timestamp) >= 0;
        }
        return true;
    }

    public boolean areAllRestrictionsFulfilled(DefaultData defaultData) {
        return this.restrictionProcessor.areAllRestrictionsFulfilled(defaultData, this.indexingRestrictionList);
    }

    public void setRestrictionProcessor(IIndexQueryRestrictionProcessor restrictionProcessor) {
        this.restrictionProcessor = restrictionProcessor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fromDate == null ? 0 : this.fromDate.hashCode());
        result = 31 * result + (CollectionUtils.isEmpty(this.indexingRestrictionList) ? 0 : this.indexingRestrictionList.hashCode());
        result = 31 * result + (int)(this.methodIdent ^ this.methodIdent >>> 32);
        result = 31 * result + (int)(this.minId ^ this.minId >>> 32);
        result = 31 * result + (int)(this.platformIdent ^ this.platformIdent >>> 32);
        result = 31 * result + (int)(this.sensorTypeIdent ^ this.sensorTypeIdent >>> 32);
        result = 31 * result + (this.toDate == null ? 0 : this.toDate.hashCode());
        if (CollectionUtils.isNotEmpty(this.objectClasses)) {
            for (Class<?> clazz : this.objectClasses) {
                result = 31 * result + clazz.getName().hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexQuery other = (IndexQuery)obj;
        if (this.fromDate == null ? other.fromDate != null : !this.fromDate.equals(other.fromDate)) {
            return false;
        }
        if (this.indexingRestrictionList == null ? other.indexingRestrictionList != null : !this.indexingRestrictionList.equals(other.indexingRestrictionList)) {
            return false;
        }
        if (this.methodIdent != other.methodIdent) {
            return false;
        }
        if (this.minId != other.minId) {
            return false;
        }
        if (this.objectClasses == null ? other.objectClasses != null : !this.objectClasses.equals(other.objectClasses)) {
            return false;
        }
        if (this.platformIdent != other.platformIdent) {
            return false;
        }
        if (this.sensorTypeIdent != other.sensorTypeIdent) {
            return false;
        }
        return !(this.toDate == null ? other.toDate != null : !this.toDate.equals(other.toDate));
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("minId", this.minId);
        toStringBuilder.append("platformIdent", this.platformIdent);
        toStringBuilder.append("sensorTypeIdent", this.sensorTypeIdent);
        toStringBuilder.append("methodIdent", this.methodIdent);
        toStringBuilder.append("objectClasses", this.objectClasses);
        toStringBuilder.append("fromDate", (Object)this.fromDate);
        toStringBuilder.append("toDate", (Object)this.toDate);
        toStringBuilder.append("indexingRestrictionList", this.indexingRestrictionList);
        return toStringBuilder.toString();
    }
}

