/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.aggregation.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.IAggregatedData;
import info.novatec.inspectit.communication.data.AggregatedHttpTimerData;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import java.io.Serializable;

public class HttpTimerDataAggregator
implements IAggregator<HttpTimerData>,
Serializable {
    private static final long serialVersionUID = 495449254866425040L;
    private boolean uriBased;
    protected boolean includeRequestMethod;

    public HttpTimerDataAggregator() {
    }

    public HttpTimerDataAggregator(boolean uriBased, boolean includeRequestMethod) {
        this.uriBased = uriBased;
        this.includeRequestMethod = includeRequestMethod;
    }

    @Override
    public void aggregate(IAggregatedData<HttpTimerData> aggregatedObject, HttpTimerData objectToAdd) {
        if (!this.uriBased && !objectToAdd.getHttpInfo().hasInspectItTaggingHeader()) {
            return;
        }
        aggregatedObject.aggregate((DefaultData)objectToAdd);
        if (!(this.includeRequestMethod || objectToAdd.getHttpInfo().getRequestMethod().equals(((HttpTimerData)aggregatedObject.getData()).getHttpInfo().getRequestMethod()) || ((HttpTimerData)aggregatedObject.getData()).getHttpInfo().getRequestMethod().equals("MULTIPLE"))) {
            ((HttpTimerData)aggregatedObject.getData()).getHttpInfo().setRequestMethod("MULTIPLE");
        }
    }

    @Override
    public IAggregatedData<HttpTimerData> getClone(HttpTimerData httpData) {
        AggregatedHttpTimerData clone = new AggregatedHttpTimerData();
        clone.setPlatformIdent(httpData.getPlatformIdent());
        clone.setSensorTypeIdent(httpData.getSensorTypeIdent());
        clone.setMethodIdent(httpData.getMethodIdent());
        clone.setCharting(httpData.isCharting());
        if (this.uriBased) {
            clone.getHttpInfo().setUri(httpData.getHttpInfo().getUri());
        } else {
            clone.getHttpInfo().setUri("n.a.");
            clone.getHttpInfo().setInspectItTaggingHeaderValue(httpData.getHttpInfo().getInspectItTaggingHeaderValue());
        }
        clone.getHttpInfo().setRequestMethod(httpData.getHttpInfo().getRequestMethod());
        return clone;
    }

    @Override
    public Object getAggregationKey(HttpTimerData httpData) {
        int prime = 31;
        int result = 0;
        result = this.uriBased ? 31 * result + (httpData.getHttpInfo().getUri() == null ? 0 : httpData.getHttpInfo().getUri().hashCode()) : 31 * result + (httpData.getHttpInfo().getInspectItTaggingHeaderValue() == null ? 0 : httpData.getHttpInfo().getInspectItTaggingHeaderValue().hashCode());
        if (this.includeRequestMethod) {
            result = 31 * result + (httpData.getHttpInfo().getRequestMethod() == null ? 0 : httpData.getHttpInfo().getRequestMethod().hashCode());
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.includeRequestMethod ? 1231 : 1237);
        result = 31 * result + (this.uriBased ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpTimerDataAggregator other = (HttpTimerDataAggregator)obj;
        if (this.includeRequestMethod != other.includeRequestMethod) {
            return false;
        }
        return this.uriBased == other.uriBased;
    }
}

