/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing;

import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.ITreeComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.RecursiveTask;

public class QueryTask<R, E>
extends RecursiveTask<List<R>> {
    private IIndexQuery query;
    private Collection<? extends ITreeComponent<R, E>> branchesToQuery;

    public QueryTask(Collection<? extends ITreeComponent<R, E>> branchesToQuery, IIndexQuery query) {
        this.query = query;
        this.branchesToQuery = branchesToQuery;
    }

    @Override
    protected List<R> compute() {
        ArrayList<RecursiveTask<List<R>>> forks = new ArrayList<RecursiveTask<List<R>>>();
        ArrayList resultList = new ArrayList();
        for (ITreeComponent<R, E> iTreeComponent : this.branchesToQuery) {
            RecursiveTask<List<R>> task = iTreeComponent.getTaskForForkJoinQuery(this.query);
            forks.add(task);
            task.fork();
        }
        for (RecursiveTask recursiveTask : forks) {
            resultList.addAll((Collection)recursiveTask.join());
        }
        return resultList;
    }
}

