/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.property.configuration.validation;

import info.novatec.inspectit.cmr.property.configuration.AbstractProperty;
import info.novatec.inspectit.cmr.property.configuration.validation.ValidationError;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

@XmlTransient
public class PropertyValidation {
    private AbstractProperty property;
    private List<ValidationError> errors = new ArrayList<ValidationError>();

    protected PropertyValidation() {
    }

    protected PropertyValidation(AbstractProperty property) {
        this.property = property;
    }

    public static PropertyValidation createFor(AbstractProperty property) {
        return new PropertyValidation(property);
    }

    public AbstractProperty getProperty() {
        return this.property;
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public void addValidationError(ValidationError error) {
        this.errors.add(error);
    }

    public boolean hasErrors() {
        return CollectionUtils.isNotEmpty(this.errors);
    }

    public int getErrorCount() {
        if (CollectionUtils.isNotEmpty(this.errors)) {
            return this.errors.size();
        }
        return 0;
    }

    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasErrors()) {
            stringBuilder.append("Property ");
            stringBuilder.append(this.getProperty().getName());
            stringBuilder.append(" can not be validated. Validation test failed because of the following errors:\n");
            for (ValidationError validationError : this.getErrors()) {
                stringBuilder.append("||- ");
                stringBuilder.append(validationError.getMessage());
            }
        } else {
            stringBuilder.append("Property ");
            stringBuilder.append(this.getProperty().getName());
            stringBuilder.append("validated without errors.");
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.errors == null ? 0 : this.errors.hashCode());
        result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyValidation other = (PropertyValidation)obj;
        if (this.errors == null ? other.errors != null : !this.errors.equals(other.errors)) {
            return false;
        }
        return !(this.property == null ? other.property != null : !this.property.equals(other.property));
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("property", (Object)this.property).append("errors", this.errors).toString();
    }
}

