/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.property.configuration.impl;

import info.novatec.inspectit.cmr.property.configuration.SingleProperty;
import info.novatec.inspectit.cmr.property.update.AbstractPropertyUpdate;
import info.novatec.inspectit.cmr.property.update.impl.PercentagePropertyUpdate;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="percentage-property")
public class PercentageProperty
extends SingleProperty<Float> {
    @XmlAttribute(name="used-value")
    private Float usedValue;
    @XmlAttribute(name="default-value", required=true)
    private Float defaultValue;

    public PercentageProperty() {
    }

    public PercentageProperty(String name, String description, String logicalName, Float defaultValue, boolean advanced, boolean serverRestartRequired) throws IllegalArgumentException {
        super(name, description, logicalName, defaultValue, advanced, serverRestartRequired);
    }

    @Override
    protected AbstractPropertyUpdate<Float> createPropertyUpdate(Float updateValue) {
        return new PercentagePropertyUpdate(this, updateValue);
    }

    @Override
    protected Float getUsedValue() {
        if (null != this.usedValue) {
            return Float.valueOf(this.usedValue.floatValue() / 100.0f);
        }
        return null;
    }

    @Override
    protected void setUsedValue(Float usedValue) {
        this.usedValue = null != usedValue ? Float.valueOf(usedValue.floatValue() * 100.0f) : null;
    }

    @Override
    public Float getDefaultValue() {
        return Float.valueOf(this.defaultValue.floatValue() / 100.0f);
    }

    @Override
    protected void setDefaultValue(Float defaultValue) {
        this.defaultValue = Float.valueOf(defaultValue.floatValue() * 100.0f);
    }

    @Override
    public Float parseLiteral(String literal) {
        try {
            return Float.valueOf(Float.parseFloat(literal));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String getFormattedValue() {
        if (null != this.usedValue) {
            return this.usedValue + "%";
        }
        return this.defaultValue + "%";
    }
}

