/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.property.configuration;

import info.novatec.inspectit.cmr.property.configuration.AbstractProperty;
import info.novatec.inspectit.cmr.property.configuration.PropertySection;
import info.novatec.inspectit.cmr.property.configuration.SingleProperty;
import info.novatec.inspectit.cmr.property.configuration.validation.PropertyValidation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.collections.CollectionUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="cmr-configuration")
public class Configuration {
    @XmlElementRef(type=PropertySection.class)
    private Set<PropertySection> sections = new HashSet<PropertySection>();

    public Map<AbstractProperty, PropertyValidation> validate() {
        HashMap<AbstractProperty, PropertyValidation> validationMap = new HashMap<AbstractProperty, PropertyValidation>();
        for (AbstractProperty property : this.getAllProperties()) {
            PropertyValidation propertyValidation = property.validate();
            if (!propertyValidation.hasErrors()) continue;
            validationMap.put(property, propertyValidation);
        }
        return validationMap;
    }

    public <T> SingleProperty<T> forLogicalName(String propertyLogicalName) {
        for (AbstractProperty property : this.getAllProperties()) {
            SingleProperty<?> returnProperty = property.forLogicalname(propertyLogicalName);
            if (null == returnProperty) continue;
            return returnProperty;
        }
        return null;
    }

    public Collection<AbstractProperty> getAllProperties() {
        HashSet<AbstractProperty> properties = new HashSet<AbstractProperty>();
        if (CollectionUtils.isNotEmpty(this.sections)) {
            for (PropertySection section : this.sections) {
                properties.addAll(section.getProperties());
            }
        }
        return properties;
    }

    public void addSection(PropertySection section) {
        this.sections.add(section);
    }

    public Set<PropertySection> getSections() {
        return this.sections;
    }

    public void setSections(Set<PropertySection> sections) {
        this.sections = sections;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sections == null ? 0 : this.sections.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Configuration other = (Configuration)obj;
        return !(this.sections == null ? other.sections != null : !this.sections.equals(other.sections));
    }
}

