/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.sysoutslf4j.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ProxyingInvocationHandler
implements InvocationHandler {
    private final Object target;
    private final Map<Method, Method> methods = new HashMap<Method, Method>();

    ProxyingInvocationHandler(Object target, Class<?> interfaceClass) {
        this.target = target;
        Method[] methodArray = interfaceClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            try {
                Method methodOnTarget = target.getClass().getMethod(method.getName(), method.getParameterTypes());
                this.methods.put(method, methodOnTarget);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Target " + target + " does not have methods to match all method signatures on class " + interfaceClass, e);
            }
            ++n2;
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method methodOnTarget = this.methods.get(method);
        return methodOnTarget.invoke(this.target, args);
    }

    public Object getTarget() {
        return this.target;
    }
}

