/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.version;

import info.novatec.inspectit.exception.enumeration.VersioningErrorCodeEnum;
import info.novatec.inspectit.version.InvalidVersionException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Version
implements Comparable<Version> {
    private int major;
    private int minor;
    private int micro;
    private int buildno;

    public Version() {
    }

    public Version(int major, int minor, int buildno) {
        this.major = major;
        this.minor = minor;
        this.buildno = buildno;
    }

    public Version(int major, int minor, int micro, int buildno) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.buildno = buildno;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public void setMicro(int micro) {
        this.micro = micro;
    }

    public int getBuildno() {
        return this.buildno;
    }

    public void setBuildno(int buildno) {
        this.buildno = buildno;
    }

    @Override
    public int compareTo(Version o) {
        return new CompareToBuilder().append(this.major, o.major).append(this.minor, o.minor).append(this.micro, o.micro).append(this.buildno, o.buildno).toComparison();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.buildno != other.buildno) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        if (this.micro != other.micro) {
            return false;
        }
        return this.minor == other.minor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.buildno;
        result = 31 * result + this.major;
        result = 31 * result + this.micro;
        result = 31 * result + this.minor;
        return result;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.micro + "." + this.buildno;
    }

    public static Version verifyAndCreate(String stringRepresentation) throws InvalidVersionException {
        Version version = new Version();
        if (StringUtils.isEmpty((String)stringRepresentation)) {
            throw new InvalidVersionException(VersioningErrorCodeEnum.VERSION_INVALID, null);
        }
        String[] splitByDot = StringUtils.split((String)stringRepresentation, (String)".");
        switch (splitByDot.length) {
            case 3: {
                version.major = Version.getIntFromString(splitByDot[0]);
                version.minor = Version.getIntFromString(splitByDot[1]);
                version.buildno = Version.getIntFromString(splitByDot[2]);
                break;
            }
            case 4: {
                version.major = Version.getIntFromString(splitByDot[0]);
                version.minor = Version.getIntFromString(splitByDot[1]);
                version.micro = Version.getIntFromString(splitByDot[2]);
                version.buildno = Version.getIntFromString(splitByDot[3]);
                break;
            }
            default: {
                throw new InvalidVersionException("The version " + stringRepresentation + " does not follow the format major.minor[.micro].build", VersioningErrorCodeEnum.VERSION_INVALID, null);
            }
        }
        return version;
    }

    private static int getIntFromString(String element) throws InvalidVersionException {
        try {
            return Integer.parseInt(element);
        }
        catch (NumberFormatException e) {
            throw new InvalidVersionException("Cannot convert sub element of the version to String", VersioningErrorCodeEnum.VERSION_INVALID, (Throwable)e);
        }
    }
}

