/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.serializer.schema;

import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.storage.serializer.schema.ClassSchema;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class ClassSchemaManager
implements InitializingBean {
    @Log
    Logger log;
    public static final String SCHEMA_DIR = "schema";
    public static final String SCHEMA_LIST_FILE = "schemaList.txt";
    private Map<String, ClassSchema> schemaMap = new HashMap<String, ClassSchema>();
    @Value(value="classpath:schema/schemaList.txt")
    private Resource schemaListFile;

    public void addSchema(ClassSchema schema) {
        if (schema != null) {
            if (this.schemaMap == null) {
                this.schemaMap = new HashMap<String, ClassSchema>();
            }
            this.schemaMap.put(schema.getClassName(), schema);
        }
    }

    public ClassSchema getSchema(String className) {
        return this.schemaMap.get(className);
    }

    public void loadSchemasFromLocations() throws IOException {
        this.log.info("||-Class Schema Manager started..");
        InputStream is = this.schemaListFile.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        ClassLoader classLoader = ClassSchemaManager.class.getClassLoader();
        String schemaLocation = br.readLine();
        while (null != schemaLocation) {
            InputStream inputStream = classLoader.getResourceAsStream(schemaLocation);
            if (null == inputStream) {
                throw new IllegalArgumentException("Schema file '" + schemaLocation + "' can not be found.");
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            this.loadSchemaFromReader(bufferedReader);
            schemaLocation = br.readLine();
            if (null != bufferedReader) {
                bufferedReader.close();
            }
            if (null != inputStreamReader) {
                inputStreamReader.close();
            }
            if (null == inputStream) continue;
            inputStream.close();
        }
        if (null != br) {
            br.close();
        }
        if (null != isr) {
            isr.close();
        }
        if (null != is) {
            is.close();
        }
    }

    protected void loadSchemas(File directory) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Schemas can not be loaded. Provided file is not a directory.");
        }
        File[] files = directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String fileName) {
                return fileName.endsWith(".sch");
            }
        });
        this.loadSchemas(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSchemas(File[] files) {
        for (File file : files) {
            FileReader fileReader = null;
            BufferedReader reader = null;
            try {
                fileReader = new FileReader(file);
                reader = new BufferedReader(fileReader);
                this.loadSchemaFromReader(reader);
            }
            catch (IOException exception) {
                this.log.warn("Exception occurred during reading the schema file.", (Throwable)exception);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (fileReader != null) {
                        fileReader.close();
                    }
                }
                catch (IOException exception) {
                    this.log.warn("Exception occurred trying to close the schema file,", (Throwable)exception);
                }
            }
        }
    }

    private void loadSchemaFromReader(BufferedReader reader) throws IOException {
        if (reader != null) {
            HashMap<String, String> schemaInitMap = new HashMap<String, String>();
            String line = reader.readLine();
            while (line != null) {
                String[] tokens;
                if (line.length() > 0 && line.charAt(0) != '#' && (tokens = line.split(":")).length == 2) {
                    schemaInitMap.put(tokens[0].trim(), tokens[1].trim());
                }
                line = reader.readLine();
            }
            ClassSchema schema = new ClassSchema(schemaInitMap);
            this.addSchema(schema);
            if (this.log.isDebugEnabled()) {
                this.log.info("||-Successfully loaded schema for class " + schema.getClassName());
            }
        }
    }

    protected Map<String, ClassSchema> getSchemaMap() {
        return Collections.unmodifiableMap(this.schemaMap);
    }

    public void setSchemaListFile(Resource schemaListFile) {
        this.schemaListFile = schemaListFile;
    }

    public void afterPropertiesSet() throws Exception {
        this.loadSchemasFromLocations();
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("schemaMap", this.schemaMap);
        return toStringBuilder.toString();
    }
}

