/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.serializer;

import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.DefaultClassResolver;
import info.novatec.inspectit.storage.serializer.impl.HibernateProxySerializer;
import info.novatec.inspectit.util.IHibernateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class HibernateAwareClassResolver
extends DefaultClassResolver {
    private IHibernateUtil hibernateUtil;
    private final Map<Class<?>, Registration> hibernateProxiesRegistrations;

    public HibernateAwareClassResolver(IHibernateUtil hibernateUtil) {
        if (null == hibernateUtil) {
            throw new IllegalArgumentException("Hibernate util is needed with creation of Hibernate aware class resolver");
        }
        this.hibernateUtil = hibernateUtil;
        this.hibernateProxiesRegistrations = new HashMap();
    }

    public Registration writeClass(Output output, Class type) {
        Class writeType = type;
        if (null != type) {
            if (this.hibernateUtil.isPersistentList(type)) {
                writeType = ArrayList.class;
            } else if (this.hibernateUtil.isPersistentSet(type)) {
                writeType = HashSet.class;
            } else if (this.hibernateUtil.isPersistentMap(type)) {
                writeType = HashMap.class;
            } else if (this.hibernateUtil.isProxy(writeType)) {
                writeType = writeType.getSuperclass();
                Registration registration = super.writeClass(output, writeType);
                Registration returnRegistration = this.hibernateProxiesRegistrations.get(writeType);
                if (null == returnRegistration) {
                    returnRegistration = new Registration(registration.getType(), (Serializer)new HibernateProxySerializer(this.hibernateUtil, (Serializer<Object>)registration.getSerializer()), registration.getId());
                    this.hibernateProxiesRegistrations.put(writeType, returnRegistration);
                }
                return returnRegistration;
            }
        }
        return super.writeClass(output, writeType);
    }
}

