/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.nio.stream;

import com.esotericsoftware.kryo.io.ByteBufferInputStream;
import info.novatec.inspectit.storage.nio.ByteBufferProvider;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtendedByteBufferInputStream
extends ByteBufferInputStream {
    private static final int MIN_BUFFERS = 2;
    private static final int MAX_BUFFERS = 5;
    @Autowired
    ByteBufferProvider byteBufferProvider;
    private int numberOfBuffers;
    private long totalSize;
    private long position;
    private LinkedBlockingQueue<ByteBuffer> emptyBuffers = new LinkedBlockingQueue();
    private LinkedBlockingQueue<ByteBuffer> fullBuffers = new LinkedBlockingQueue();
    private volatile boolean closed;

    public AbstractExtendedByteBufferInputStream() {
    }

    public AbstractExtendedByteBufferInputStream(int numberOfBuffers) {
        this.numberOfBuffers = numberOfBuffers;
    }

    public void prepare() throws IOException {
        int buffers = this.numberOfBuffers;
        if (buffers < 2) {
            buffers = 2;
        } else if (buffers > 5) {
            buffers = 5;
        }
        for (int i = 0; i < buffers; ++i) {
            ByteBuffer byteBuffer = this.byteBufferProvider.acquireByteBuffer();
            this.emptyBuffers.add(byteBuffer);
        }
    }

    public boolean hasRemaining() {
        return this.bytesLeft() > 0L;
    }

    public int available() throws IOException {
        return (int)this.bytesLeft();
    }

    public int read() throws IOException {
        if (0L == this.totalSize || !this.hasRemaining()) {
            return -1;
        }
        if (this.hasRemaining() || null == super.getByteBuffer()) {
            this.bufferChange();
        }
        if (!super.getByteBuffer().hasRemaining()) {
            if (this.bytesLeft() > 0L) {
                this.bufferChange();
                int read = super.read();
                this.position += (long)read;
                return read;
            }
            return -1;
        }
        int read = super.read();
        this.position += (long)read;
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bufferRemaining;
        if (0L == this.totalSize || !this.hasRemaining()) {
            return -1;
        }
        if (0 == len) {
            return 0;
        }
        if (this.hasRemaining() && null == super.getByteBuffer()) {
            this.bufferChange();
        }
        if ((bufferRemaining = super.getByteBuffer().remaining()) >= len) {
            int read = super.read(b, off, len);
            this.position += (long)read;
            return read;
        }
        int res = 0;
        if (bufferRemaining > 0) {
            super.getByteBuffer().get(b, off, bufferRemaining);
            res = bufferRemaining;
            this.position += (long)bufferRemaining;
        }
        if (this.bytesLeft() > 0L) {
            this.bufferChange();
            int read = this.read(b, off + bufferRemaining, len - bufferRemaining);
            res += read;
        }
        if (res > 0) {
            return res;
        }
        return -1;
    }

    private synchronized void bufferChange() {
        ByteBuffer current = super.getByteBuffer();
        if (null != current) {
            current.clear();
            this.emptyBuffers.add(current);
        }
        try {
            super.setByteBuffer(this.fullBuffers.take());
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    private long bytesLeft() {
        return this.totalSize - this.position;
    }

    public synchronized void close() throws IOException {
        ByteBuffer byteBuffer;
        if (this.closed) {
            return;
        }
        while (!this.fullBuffers.isEmpty()) {
            byteBuffer = this.fullBuffers.poll();
            if (null == byteBuffer) continue;
            this.byteBufferProvider.releaseByteBuffer(byteBuffer);
        }
        while (!this.emptyBuffers.isEmpty()) {
            byteBuffer = this.emptyBuffers.poll();
            if (null == byteBuffer) continue;
            this.byteBufferProvider.releaseByteBuffer(byteBuffer);
        }
        ByteBuffer currentBuffer = super.getByteBuffer();
        if (null != currentBuffer) {
            this.byteBufferProvider.releaseByteBuffer(currentBuffer);
            super.setByteBuffer(null);
        }
        this.closed = true;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public LinkedBlockingQueue<ByteBuffer> getEmptyBuffers() {
        return this.emptyBuffers;
    }

    public LinkedBlockingQueue<ByteBuffer> getFullBuffers() {
        return this.fullBuffers;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setByteBufferProvider(ByteBufferProvider byteBufferProvider) {
        this.byteBufferProvider = byteBufferProvider;
    }

    protected void setPosition(long position) {
        this.position = position;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

