/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.SystemSensorData;
import java.sql.Timestamp;
import javax.persistence.Entity;

@Entity
public class RuntimeInformationData
extends SystemSensorData {
    private static final long serialVersionUID = -6969524429547729867L;
    private int count = 0;
    private long minUptime = Long.MAX_VALUE;
    private long maxUptime = 0L;
    private long totalUptime = 0L;

    public RuntimeInformationData() {
    }

    public RuntimeInformationData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent) {
        super(timeStamp, platformIdent, sensorTypeIdent);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void incrementCount() {
        ++this.count;
    }

    public void addUptime(long uptime) {
        this.totalUptime += uptime;
    }

    public long getMinUptime() {
        return this.minUptime;
    }

    public void setMinUptime(long minUptime) {
        this.minUptime = minUptime;
    }

    public long getMaxUptime() {
        return this.maxUptime;
    }

    public void setMaxUptime(long maxUptime) {
        this.maxUptime = maxUptime;
    }

    public long getTotalUptime() {
        return this.totalUptime;
    }

    public void setTotalUptime(long totalUptime) {
        this.totalUptime = totalUptime;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.count;
        result = 31 * result + (int)(this.maxUptime ^ this.maxUptime >>> 32);
        result = 31 * result + (int)(this.minUptime ^ this.minUptime >>> 32);
        result = 31 * result + (int)(this.totalUptime ^ this.totalUptime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuntimeInformationData other = (RuntimeInformationData)obj;
        if (this.count != other.count) {
            return false;
        }
        if (this.maxUptime != other.maxUptime) {
            return false;
        }
        if (this.minUptime != other.minUptime) {
            return false;
        }
        return this.totalUptime == other.totalUptime;
    }

    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = super.getObjectSize(objectSizes, doAlign);
        size += objectSizes.getPrimitiveTypesSize(0, 0, 1, 0, 3, 0);
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }
}

