/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.Sizeable;
import info.novatec.inspectit.communication.data.ParameterContentType;
import info.novatec.inspectit.util.ObjectUtils;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class ParameterContentData
implements Serializable,
Sizeable,
Comparable<ParameterContentData> {
    private static final long serialVersionUID = -8005782295084781051L;
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE)
    private long id;
    private String name;
    @Column(length=10000)
    private String content;
    @Enumerated(value=EnumType.STRING)
    private ParameterContentType contentType;
    private int signaturePosition = -1;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public ParameterContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ParameterContentType contentType) {
        this.contentType = contentType;
    }

    public int getSignaturePosition() {
        return this.signaturePosition;
    }

    public void setSignaturePosition(int signaturePosition) {
        this.signaturePosition = signaturePosition;
    }

    @Override
    public long getObjectSize(IObjectSizes objectSizes) {
        return this.getObjectSize(objectSizes, true);
    }

    @Override
    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = objectSizes.getSizeOfObjectHeader();
        size += objectSizes.getPrimitiveTypesSize(3, 0, 1, 0, 1, 0);
        size += objectSizes.getSizeOf(this.content);
        size += objectSizes.getSizeOf(this.name);
        size += objectSizes.getSizeOf(this.contentType);
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }

    @Override
    public int compareTo(ParameterContentData other) {
        return ObjectUtils.compare(this.name, other.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.signaturePosition;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterContentData other = (ParameterContentData)obj;
        if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
            return false;
        }
        if (this.contentType == null ? other.contentType != null : !this.contentType.equals(other.contentType)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.signaturePosition == other.signaturePosition;
    }

    public String toString() {
        return this.content;
    }
}

