/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.MethodSensorData;
import info.novatec.inspectit.communication.data.ParameterContentData;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public abstract class InvocationAwareData
extends MethodSensorData {
    private static final long serialVersionUID = 1321146768671989693L;
    @Transient
    private Map<Long, MutableInt> invocationsParentsIdMap;

    public InvocationAwareData() {
    }

    public InvocationAwareData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent, long methodIdent) {
        super(timeStamp, platformIdent, sensorTypeIdent, methodIdent);
    }

    public InvocationAwareData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent, long methodIdent, List<ParameterContentData> parameterContentData) {
        super(timeStamp, platformIdent, sensorTypeIdent, methodIdent, parameterContentData);
    }

    public void addInvocationParentId(Long id) {
        if (null != id) {
            MutableInt count;
            if (null == this.invocationsParentsIdMap) {
                this.invocationsParentsIdMap = new HashMap<Long, MutableInt>();
            }
            if (null != (count = this.invocationsParentsIdMap.get(id))) {
                count.increase();
            } else {
                this.invocationsParentsIdMap.put(id, new MutableInt(1));
            }
        }
    }

    public Set<Long> getInvocationParentsIdSet() {
        if (null != this.invocationsParentsIdMap) {
            return this.invocationsParentsIdMap.keySet();
        }
        return Collections.emptySet();
    }

    public Map<Long, MutableInt> getInvocationsParentsIdMap() {
        return this.invocationsParentsIdMap;
    }

    public void setInvocationsParentsIdMap(Map<Long, MutableInt> invocationsParentsIdMap) {
        this.invocationsParentsIdMap = invocationsParentsIdMap;
    }

    public int getObjectsInInvocationsCount() {
        int count = 0;
        if (null != this.invocationsParentsIdMap) {
            for (MutableInt parentId : this.invocationsParentsIdMap.values()) {
                count += parentId.getValue();
            }
        }
        return count;
    }

    public void aggregateInvocationAwareData(InvocationAwareData invocationAwareData) {
        if (null != invocationAwareData.getInvocationsParentsIdMap()) {
            if (null == this.invocationsParentsIdMap) {
                this.invocationsParentsIdMap = new HashMap<Long, MutableInt>();
            }
            for (Map.Entry<Long, MutableInt> entry : invocationAwareData.getInvocationsParentsIdMap().entrySet()) {
                MutableInt count = this.invocationsParentsIdMap.get(entry.getKey());
                if (null != count) {
                    count.add(entry.getValue().getValue());
                    continue;
                }
                this.invocationsParentsIdMap.put(entry.getKey(), new MutableInt(entry.getValue().getValue()));
            }
        }
    }

    public abstract double getInvocationAffiliationPercentage();

    public boolean isOnlyFoundInInvocations() {
        return this.getInvocationAffiliationPercentage() == 1.0;
    }

    public boolean isOnlyFoundOutsideInvocations() {
        return this.getInvocationAffiliationPercentage() == 0.0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.invocationsParentsIdMap == null ? 0 : this.invocationsParentsIdMap.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InvocationAwareData other = (InvocationAwareData)obj;
        return !(this.invocationsParentsIdMap == null ? other.invocationsParentsIdMap != null : !this.invocationsParentsIdMap.equals(other.invocationsParentsIdMap));
    }

    @Override
    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = super.getObjectSize(objectSizes, doAlign);
        size += objectSizes.getPrimitiveTypesSize(1, 0, 0, 0, 0, 0);
        if (null != this.invocationsParentsIdMap) {
            size += objectSizes.getSizeOfHashMap(this.invocationsParentsIdMap.size());
            size += (long)this.invocationsParentsIdMap.size() * objectSizes.getSizeOfLongObject();
            long sizeOfMutableInt = objectSizes.alignTo8Bytes(objectSizes.getSizeOfObjectHeader() + objectSizes.getPrimitiveTypesSize(0, 0, 1, 0, 0, 0));
            size += (long)this.invocationsParentsIdMap.size() * sizeOfMutableInt;
        }
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }

    public static class MutableInt
    implements Serializable {
        private static final long serialVersionUID = -2367937702260302863L;
        private int value;

        public MutableInt() {
        }

        public MutableInt(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void increase() {
            ++this.value;
        }

        public void add(int delta) {
            this.value += delta;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.value;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MutableInt other = (MutableInt)obj;
            return this.value == other.value;
        }
    }
}

