/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.ExceptionEvent;
import info.novatec.inspectit.communication.data.InvocationAwareData;
import java.sql.Timestamp;

public class ExceptionSensorData
extends InvocationAwareData {
    private static final long serialVersionUID = -8064862129447036553L;
    private String errorMessage;
    private String cause;
    private String stackTrace;
    private ExceptionEvent exceptionEvent;
    private String throwableType;
    private ExceptionSensorData child;
    private long throwableIdentityHashCode;

    public ExceptionSensorData() {
    }

    public ExceptionSensorData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent, long methodIdent) {
        super(timeStamp, platformIdent, sensorTypeIdent, methodIdent);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getCause() {
        return this.cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public ExceptionEvent getExceptionEvent() {
        return this.exceptionEvent;
    }

    public void setExceptionEvent(ExceptionEvent exceptionEvent) {
        this.exceptionEvent = exceptionEvent;
    }

    public String getThrowableType() {
        return this.throwableType;
    }

    public void setThrowableType(String throwableType) {
        this.throwableType = throwableType;
    }

    public ExceptionSensorData getChild() {
        return this.child;
    }

    public void setChild(ExceptionSensorData child) {
        this.child = child;
    }

    public long getThrowableIdentityHashCode() {
        return this.throwableIdentityHashCode;
    }

    public void setThrowableIdentityHashCode(long throwableIdentityHashCode) {
        this.throwableIdentityHashCode = throwableIdentityHashCode;
    }

    public double getInvocationAffiliationPercentage() {
        return (double)this.getObjectsInInvocationsCount() / 1.0;
    }

    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = super.getObjectSize(objectSizes, doAlign);
        size += objectSizes.getPrimitiveTypesSize(6, 0, 0, 0, 1, 0);
        size += objectSizes.getSizeOf(this.errorMessage);
        size += objectSizes.getSizeOf(this.cause);
        size += objectSizes.getSizeOf(this.stackTrace);
        size += objectSizes.getSizeOf(this.throwableType);
        size += objectSizes.getSizeOf(this.exceptionEvent);
        size += objectSizes.getSizeOf(this.child);
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.cause == null ? 0 : this.cause.hashCode());
        result = 31 * result + (this.child == null ? 0 : this.child.hashCode());
        result = 31 * result + (this.exceptionEvent == null ? 0 : this.exceptionEvent.hashCode());
        result = 31 * result + (this.stackTrace == null ? 0 : this.stackTrace.hashCode());
        result = 31 * result + (int)(this.throwableIdentityHashCode ^ this.throwableIdentityHashCode >>> 32);
        result = 31 * result + (this.throwableType == null ? 0 : this.throwableType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExceptionSensorData other = (ExceptionSensorData)obj;
        if (this.cause == null ? other.cause != null : !this.cause.equals(other.cause)) {
            return false;
        }
        if (this.child == null ? other.child != null : !this.child.equals(other.child)) {
            return false;
        }
        if (this.exceptionEvent == null ? other.exceptionEvent != null : !this.exceptionEvent.equals(other.exceptionEvent)) {
            return false;
        }
        if (this.stackTrace == null ? other.stackTrace != null : !this.stackTrace.equals(other.stackTrace)) {
            return false;
        }
        if (this.throwableIdentityHashCode != other.throwableIdentityHashCode) {
            return false;
        }
        return !(this.throwableType == null ? other.throwableType != null : !this.throwableType.equals(other.throwableType));
    }

    public String toString() {
        return this.throwableType + "@" + this.throwableIdentityHashCode;
    }
}

