/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.IAggregatedData;
import info.novatec.inspectit.communication.SystemSensorData;
import java.sql.Timestamp;
import javax.persistence.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class CpuInformationData
extends SystemSensorData
implements IAggregatedData<CpuInformationData> {
    private static final long serialVersionUID = 3575761562499283807L;
    private int count = 0;
    private long processCpuTime = 0L;
    private float minCpuUsage = Float.MAX_VALUE;
    private float maxCpuUsage = 0.0f;
    private float totalCpuUsage = 0.0f;

    public CpuInformationData() {
    }

    public CpuInformationData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent) {
        super(timeStamp, platformIdent, sensorTypeIdent);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void incrementCount() {
        ++this.count;
    }

    public void updateProcessCpuTime(long actualProcessCpuTime) {
        if (actualProcessCpuTime > this.processCpuTime) {
            this.processCpuTime = actualProcessCpuTime;
        }
    }

    public long getProcessCpuTime() {
        return this.processCpuTime;
    }

    public void setProcessCpuTime(long processCpuTime) {
        this.processCpuTime = processCpuTime;
    }

    public void addCpuUsage(float cpuUsage) {
        this.totalCpuUsage += cpuUsage;
    }

    public float getMinCpuUsage() {
        return this.minCpuUsage;
    }

    public void setMinCpuUsage(float minCpuUsage) {
        this.minCpuUsage = minCpuUsage;
    }

    public float getMaxCpuUsage() {
        return this.maxCpuUsage;
    }

    public void setMaxCpuUsage(float maxCpuUsage) {
        this.maxCpuUsage = maxCpuUsage;
    }

    public float getTotalCpuUsage() {
        return this.totalCpuUsage;
    }

    public void setTotalCpuUsage(float totalCpuUsage) {
        this.totalCpuUsage = totalCpuUsage;
    }

    @Override
    public void aggregate(CpuInformationData other) {
        this.count += other.count;
        this.processCpuTime += other.processCpuTime;
        this.minCpuUsage = Math.min(this.minCpuUsage, other.minCpuUsage);
        this.maxCpuUsage = Math.max(this.maxCpuUsage, other.maxCpuUsage);
        this.totalCpuUsage += other.totalCpuUsage;
    }

    @Override
    public CpuInformationData getData() {
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.count;
        result = 31 * result + Float.floatToIntBits(this.maxCpuUsage);
        result = 31 * result + Float.floatToIntBits(this.minCpuUsage);
        result = 31 * result + (int)(this.processCpuTime ^ this.processCpuTime >>> 32);
        result = 31 * result + Float.floatToIntBits(this.totalCpuUsage);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CpuInformationData other = (CpuInformationData)obj;
        if (this.count != other.count) {
            return false;
        }
        if (Float.floatToIntBits(this.maxCpuUsage) != Float.floatToIntBits(other.maxCpuUsage)) {
            return false;
        }
        if (Float.floatToIntBits(this.minCpuUsage) != Float.floatToIntBits(other.minCpuUsage)) {
            return false;
        }
        if (this.processCpuTime != other.processCpuTime) {
            return false;
        }
        return Float.floatToIntBits(this.totalCpuUsage) == Float.floatToIntBits(other.totalCpuUsage);
    }

    @Override
    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = super.getObjectSize(objectSizes, doAlign);
        size += objectSizes.getPrimitiveTypesSize(0, 0, 1, 3, 1, 0);
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }
}

