/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.data;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.IIdsAwareAggregatedData;
import info.novatec.inspectit.communication.data.HttpTimerData;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatedHttpTimerData
extends HttpTimerData
implements IIdsAwareAggregatedData<HttpTimerData> {
    private static final long serialVersionUID = -6077701184038575208L;
    private Map<Long, Boolean> aggregatedIds = new ConcurrentHashMap<Long, Boolean>(16, 0.75f, 4);

    @Override
    public void aggregate(HttpTimerData data) {
        this.aggregateHttpTimerData(data);
        if (data instanceof AggregatedHttpTimerData) {
            AggregatedHttpTimerData aggregatedData = (AggregatedHttpTimerData)data;
            if (null != aggregatedData.getAggregatedIds()) {
                for (Long id : aggregatedData.getAggregatedIds()) {
                    this.aggregatedIds.put(id, Boolean.TRUE);
                }
            }
        } else if (0L != data.getId()) {
            this.aggregatedIds.put(data.getId(), Boolean.TRUE);
        }
    }

    @Override
    public Collection<Long> getAggregatedIds() {
        return this.aggregatedIds.keySet();
    }

    @Override
    public void clearAggregatedIds() {
        this.aggregatedIds.clear();
    }

    @Override
    public HttpTimerData getData() {
        return this;
    }

    public void aggregateHttpTimerData(HttpTimerData data) {
        super.aggregateTimerData(data);
    }

    @Override
    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = super.getObjectSize(objectSizes, doAlign);
        size += objectSizes.getPrimitiveTypesSize(1, 0, 0, 0, 0, 0);
        if (null != this.aggregatedIds) {
            size += objectSizes.getSizeOfConcurrentHashMap(this.aggregatedIds.size(), 4);
            size += (long)this.aggregatedIds.size() * objectSizes.getSizeOfLongObject();
        }
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.aggregatedIds == null ? 0 : this.aggregatedIds.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggregatedHttpTimerData other = (AggregatedHttpTimerData)obj;
        return !(this.aggregatedIds == null ? other.aggregatedIds != null : !this.aggregatedIds.equals(other.aggregatedIds));
    }
}

