/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.comparator;

import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.communication.comparator.IDataComparator;
import info.novatec.inspectit.communication.data.TimerData;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TimerDataComparatorEnum implements IDataComparator<TimerData>,
Comparator<TimerData>
{
    COUNT,
    AVERAGE,
    MIN,
    MAX,
    DURATION,
    CPUAVERAGE,
    CPUMIN,
    CPUMAX,
    CPUDURATION,
    EXCLUSIVEAVERAGE,
    EXCLUSIVEMIN,
    EXCLUSIVEMAX,
    EXCLUSIVEDURATION,
    CHARTING;


    @Override
    public int compare(TimerData o1, TimerData o2, ICachedDataService cachedDataService) {
        return this.compare(o1, o2);
    }

    @Override
    public int compare(TimerData o1, TimerData o2) {
        switch (this) {
            case COUNT: {
                return Long.valueOf(o1.getCount()).compareTo(o2.getCount());
            }
            case AVERAGE: {
                return Double.compare(o1.getAverage(), o2.getAverage());
            }
            case MIN: {
                return Double.compare(o1.getMin(), o2.getMin());
            }
            case MAX: {
                return Double.compare(o1.getMax(), o2.getMax());
            }
            case DURATION: {
                return Double.compare(o1.getDuration(), o2.getDuration());
            }
            case CPUAVERAGE: {
                return Double.compare(o1.getCpuAverage(), o2.getCpuAverage());
            }
            case CPUMIN: {
                return Double.compare(o1.getCpuMin(), o2.getCpuMin());
            }
            case CPUMAX: {
                return Double.compare(o1.getCpuMax(), o2.getCpuMax());
            }
            case CPUDURATION: {
                return Double.compare(o1.getCpuDuration(), o2.getCpuDuration());
            }
            case EXCLUSIVEAVERAGE: {
                return Double.compare(o1.getExclusiveAverage(), o2.getExclusiveAverage());
            }
            case EXCLUSIVEMIN: {
                return Double.compare(o1.getExclusiveMin(), o2.getExclusiveMin());
            }
            case EXCLUSIVEMAX: {
                return Double.compare(o1.getExclusiveMax(), o2.getExclusiveMax());
            }
            case EXCLUSIVEDURATION: {
                return Double.compare(o1.getExclusiveDuration(), o2.getExclusiveDuration());
            }
            case CHARTING: {
                return Boolean.valueOf(o1.isCharting()).compareTo(o2.isCharting());
            }
        }
        return 0;
    }
}

