/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication.comparator;

import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.comparator.IDataComparator;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultComparator<T extends DefaultData>
implements Comparator<T> {
    private IDataComparator<? super T> comparator;
    private ICachedDataService cachedDataService;
    private boolean ascending = true;

    public ResultComparator() {
    }

    public ResultComparator(IDataComparator<? super T> comparator) {
        this(comparator, null, true);
    }

    public ResultComparator(IDataComparator<? super T> comparator, boolean ascending) {
        this(comparator, null, ascending);
    }

    public ResultComparator(IDataComparator<? super T> comparator, ICachedDataService cachedDataService) {
        this(comparator, cachedDataService, true);
    }

    public ResultComparator(IDataComparator<? super T> comparator, ICachedDataService cachedDataService, boolean ascending) {
        this.comparator = comparator;
        this.ascending = ascending;
        this.cachedDataService = cachedDataService;
    }

    @Override
    public int compare(T o1, T o2) {
        int res = this.comparator.compare(o1, o2, this.cachedDataService);
        if (!this.ascending && res != 0) {
            return res * -1;
        }
        return res;
    }

    public ICachedDataService getCachedDataService() {
        return this.cachedDataService;
    }

    public void setCachedDataService(ICachedDataService cachedDataService) {
        this.cachedDataService = cachedDataService;
    }

    public IDataComparator<? super T> getComparator() {
        return this.comparator;
    }

    public void setComparator(IDataComparator<? super T> comparator) {
        this.comparator = comparator;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }
}

