/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.communication;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.Sizeable;
import info.novatec.inspectit.indexing.IIndexQuery;
import java.io.Serializable;
import java.sql.Timestamp;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.validation.constraints.NotNull;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@NamedQuery(name="DefaultData.deleteForPlatformId", query="DELETE FROM DefaultData d WHERE d.platformIdent=:platformIdent")
public abstract class DefaultData
implements Serializable,
Sizeable {
    private static final long serialVersionUID = 5195625080367033147L;
    public static final String DELETE_FOR_PLATFORM_ID = "DefaultData.deleteForPlatformId";
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DEFAULT_DATA_SEQUENCE")
    @SequenceGenerator(name="DEFAULT_DATA_SEQUENCE", sequenceName="DEFAULT_DATA_SEQUENCE")
    private long id;
    private long platformIdent;
    private long sensorTypeIdent;
    @NotNull
    private Timestamp timeStamp;

    public DefaultData() {
    }

    public DefaultData(Timestamp timeStamp, long platformIdent, long sensorTypeIdent) {
        this.timeStamp = timeStamp;
        this.platformIdent = platformIdent;
        this.sensorTypeIdent = sensorTypeIdent;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getPlatformIdent() {
        return this.platformIdent;
    }

    public void setPlatformIdent(long platformIdent) {
        this.platformIdent = platformIdent;
    }

    public long getSensorTypeIdent() {
        return this.sensorTypeIdent;
    }

    public void setSensorTypeIdent(long sensorTypeIdent) {
        this.sensorTypeIdent = sensorTypeIdent;
    }

    public Timestamp getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Timestamp timeStamp) {
        this.timeStamp = timeStamp;
    }

    public DefaultData finalizeData() {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.platformIdent ^ this.platformIdent >>> 32);
        result = 31 * result + (int)(this.sensorTypeIdent ^ this.sensorTypeIdent >>> 32);
        result = 31 * result + (this.timeStamp == null ? 0 : this.timeStamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultData other = (DefaultData)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.platformIdent != other.platformIdent) {
            return false;
        }
        if (this.sensorTypeIdent != other.sensorTypeIdent) {
            return false;
        }
        return !(this.timeStamp == null ? other.timeStamp != null : !this.timeStamp.equals(other.timeStamp));
    }

    public long getObjectSize(IObjectSizes objectSizes) {
        return this.getObjectSize(objectSizes, true);
    }

    public long getObjectSize(IObjectSizes objectSizes, boolean doAlign) {
        long size = objectSizes.getSizeOfObjectHeader();
        size += objectSizes.getPrimitiveTypesSize(1, 0, 0, 0, 3, 0);
        size += objectSizes.getSizeOf(this.timeStamp);
        if (doAlign) {
            return objectSizes.alignTo8Bytes(size);
        }
        return size;
    }

    public boolean isQueryComplied(IIndexQuery query) {
        if (query.getObjectClasses() != null && !query.getObjectClasses().contains(this.getClass())) {
            return false;
        }
        if (query.getMinId() > this.id) {
            return false;
        }
        if (query.getPlatformIdent() != 0L && query.getPlatformIdent() != this.platformIdent) {
            return false;
        }
        if (query.getSensorTypeIdent() != 0L && query.getSensorTypeIdent() != this.sensorTypeIdent) {
            return false;
        }
        if (!query.isInInterval(this.timeStamp)) {
            return false;
        }
        return query.areAllRestrictionsFulfilled(this);
    }
}

