/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.sun.nio.file.ExtendedOpenOption;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Set;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;
import sun.nio.ch.FileChannelImpl;
import sun.nio.ch.ThreadPool;
import sun.nio.ch.WindowsAsynchronousFileChannelImpl;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsNativeDispatcher;

class WindowsChannelFactory {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    static final OpenOption OPEN_REPARSE_POINT = new OpenOption(){};

    private WindowsChannelFactory() {
    }

    static FileChannel newFileChannel(String string, String string2, Set<? extends OpenOption> set, long l) throws WindowsException {
        Flags flags = Flags.toFlags(set);
        if (!flags.read && !flags.write) {
            if (flags.append) {
                flags.write = true;
            } else {
                flags.read = true;
            }
        }
        if (flags.read && flags.append) {
            throw new IllegalArgumentException("READ + APPEND not allowed");
        }
        if (flags.append && flags.truncateExisting) {
            throw new IllegalArgumentException("APPEND + TRUNCATE_EXISTING not allowed");
        }
        FileDescriptor fileDescriptor = WindowsChannelFactory.open(string, string2, flags, l);
        return FileChannelImpl.open(fileDescriptor, string, flags.read, flags.write, flags.append, null);
    }

    static AsynchronousFileChannel newAsynchronousFileChannel(String string, String string2, Set<? extends OpenOption> set, long l, ThreadPool threadPool) throws IOException {
        FileDescriptor fileDescriptor;
        Flags flags = Flags.toFlags(set);
        flags.overlapped = true;
        if (!flags.read && !flags.write) {
            flags.read = true;
        }
        if (flags.append) {
            throw new UnsupportedOperationException("APPEND not allowed");
        }
        try {
            fileDescriptor = WindowsChannelFactory.open(string, string2, flags, l);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(string);
            return null;
        }
        try {
            return WindowsAsynchronousFileChannelImpl.open(fileDescriptor, flags.read, flags.write, threadPool);
        }
        catch (IOException iOException) {
            long l2 = fdAccess.getHandle(fileDescriptor);
            WindowsNativeDispatcher.CloseHandle(l2);
            throw iOException;
        }
    }

    private static FileDescriptor open(String string, String string2, Flags flags, long l) throws WindowsException {
        SecurityManager securityManager;
        boolean bl = false;
        int n = 0;
        if (flags.read) {
            n |= Integer.MIN_VALUE;
        }
        if (flags.write) {
            n |= 0x40000000;
        }
        int n2 = 0;
        if (flags.shareRead) {
            n2 |= 1;
        }
        if (flags.shareWrite) {
            n2 |= 2;
        }
        if (flags.shareDelete) {
            n2 |= 4;
        }
        int n3 = 128;
        int n4 = 3;
        if (flags.write) {
            if (flags.createNew) {
                n4 = 1;
                n3 |= 0x200000;
            } else {
                if (flags.create) {
                    n4 = 4;
                }
                if (flags.truncateExisting) {
                    if (n4 == 4) {
                        bl = true;
                    } else {
                        n4 = 5;
                    }
                }
            }
        }
        if (flags.dsync || flags.sync) {
            n3 |= Integer.MIN_VALUE;
        }
        if (flags.overlapped) {
            n3 |= 0x40000000;
        }
        if (flags.deleteOnClose) {
            n3 |= 0x4000000;
        }
        boolean bl2 = true;
        if (n4 != 1 && (flags.noFollowLinks || flags.openReparsePoint || flags.deleteOnClose)) {
            if (flags.noFollowLinks || flags.deleteOnClose) {
                bl2 = false;
            }
            n3 |= 0x200000;
        }
        if (string2 != null && (securityManager = System.getSecurityManager()) != null) {
            if (flags.read) {
                securityManager.checkRead(string2);
            }
            if (flags.write) {
                securityManager.checkWrite(string2);
            }
            if (flags.deleteOnClose) {
                securityManager.checkDelete(string2);
            }
        }
        long l2 = WindowsNativeDispatcher.CreateFile(string, n, n2, l, n4, n3);
        if (!bl2) {
            try {
                if (WindowsFileAttributes.readAttributes(l2).isSymbolicLink()) {
                    throw new WindowsException("File is symbolic link");
                }
            }
            catch (WindowsException windowsException) {
                WindowsNativeDispatcher.CloseHandle(l2);
                throw windowsException;
            }
        }
        if (bl) {
            try {
                WindowsNativeDispatcher.SetEndOfFile(l2);
            }
            catch (WindowsException windowsException) {
                WindowsNativeDispatcher.CloseHandle(l2);
                throw windowsException;
            }
        }
        if (n4 == 1 && flags.sparse) {
            try {
                WindowsNativeDispatcher.DeviceIoControlSetSparse(l2);
            }
            catch (WindowsException windowsException) {
                // empty catch block
            }
        }
        FileDescriptor fileDescriptor = new FileDescriptor();
        fdAccess.setHandle(fileDescriptor, l2);
        return fileDescriptor;
    }

    private static class Flags {
        boolean read;
        boolean write;
        boolean append;
        boolean truncateExisting;
        boolean create;
        boolean createNew;
        boolean deleteOnClose;
        boolean sparse;
        boolean overlapped;
        boolean sync;
        boolean dsync;
        boolean shareRead = true;
        boolean shareWrite = true;
        boolean shareDelete = true;
        boolean noFollowLinks;
        boolean openReparsePoint;

        private Flags() {
        }

        static Flags toFlags(Set<? extends OpenOption> set) {
            Flags flags = new Flags();
            block17: for (OpenOption openOption : set) {
                if (openOption instanceof StandardOpenOption) {
                    switch ((StandardOpenOption)openOption) {
                        case READ: {
                            flags.read = true;
                            continue block17;
                        }
                        case WRITE: {
                            flags.write = true;
                            continue block17;
                        }
                        case APPEND: {
                            flags.append = true;
                            continue block17;
                        }
                        case TRUNCATE_EXISTING: {
                            flags.truncateExisting = true;
                            continue block17;
                        }
                        case CREATE: {
                            flags.create = true;
                            continue block17;
                        }
                        case CREATE_NEW: {
                            flags.createNew = true;
                            continue block17;
                        }
                        case DELETE_ON_CLOSE: {
                            flags.deleteOnClose = true;
                            continue block17;
                        }
                        case SPARSE: {
                            flags.sparse = true;
                            continue block17;
                        }
                        case SYNC: {
                            flags.sync = true;
                            continue block17;
                        }
                        case DSYNC: {
                            flags.dsync = true;
                            continue block17;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
                if (openOption instanceof ExtendedOpenOption) {
                    switch ((ExtendedOpenOption)openOption) {
                        case NOSHARE_READ: {
                            flags.shareRead = false;
                            continue block17;
                        }
                        case NOSHARE_WRITE: {
                            flags.shareWrite = false;
                            continue block17;
                        }
                        case NOSHARE_DELETE: {
                            flags.shareDelete = false;
                            continue block17;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
                if (openOption == LinkOption.NOFOLLOW_LINKS) {
                    flags.noFollowLinks = true;
                    continue;
                }
                if (openOption == OPEN_REPARSE_POINT) {
                    flags.openReparsePoint = true;
                    continue;
                }
                if (openOption == null) {
                    throw new NullPointerException();
                }
                throw new UnsupportedOperationException();
            }
            return flags;
        }
    }
}

